// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains a summary of a gateway.
 */
public class GatewaySummary private constructor(builder: Builder) {
    /**
     * The date the gateway was created, in Unix epoch time.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationDate) { "A non-null value must be provided for creationDate" }
    /**
     * A list of gateway capability summaries that each contain a namespace and status. Each gateway capability defines data sources for the gateway. To retrieve a capability configuration's definition, use [DescribeGatewayCapabilityConfiguration](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGatewayCapabilityConfiguration.html).
     */
    public val gatewayCapabilitySummaries: List<GatewayCapabilitySummary>? = builder.gatewayCapabilitySummaries
    /**
     * The ID of the gateway device.
     */
    public val gatewayId: kotlin.String = requireNotNull(builder.gatewayId) { "A non-null value must be provided for gatewayId" }
    /**
     * The name of the gateway.
     */
    public val gatewayName: kotlin.String = requireNotNull(builder.gatewayName) { "A non-null value must be provided for gatewayName" }
    /**
     * The gateway's platform configuration. You can only specify one platform type in a gateway.
     *
     * (Legacy only) For Greengrass V1 gateways, specify the `greengrass` parameter with a valid Greengrass group ARN.
     *
     * For Greengrass V2 gateways, specify the `greengrassV2` parameter with a valid core device thing name. If creating a V3 gateway (`gatewayVersion=3`), you must also specify the `coreDeviceOperatingSystem`.
     *
     * For Siemens Industrial Edge gateways, specify the `siemensIE` parameter with a valid IoT Core thing name.
     */
    public val gatewayPlatform: aws.sdk.kotlin.services.iotsitewise.model.GatewayPlatform? = builder.gatewayPlatform
    /**
     * The version of the gateway. A value of `3` indicates an MQTT-enabled, V3 gateway, while `2` indicates a Classic streams, V2 gateway.
     */
    public val gatewayVersion: kotlin.String? = builder.gatewayVersion
    /**
     * The date the gateway was last updated, in Unix epoch time.
     */
    public val lastUpdateDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastUpdateDate) { "A non-null value must be provided for lastUpdateDate" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.GatewaySummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GatewaySummary(")
        append("creationDate=$creationDate,")
        append("gatewayCapabilitySummaries=$gatewayCapabilitySummaries,")
        append("gatewayId=$gatewayId,")
        append("gatewayName=$gatewayName,")
        append("gatewayPlatform=$gatewayPlatform,")
        append("gatewayVersion=$gatewayVersion,")
        append("lastUpdateDate=$lastUpdateDate")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationDate.hashCode()
        result = 31 * result + (gatewayCapabilitySummaries?.hashCode() ?: 0)
        result = 31 * result + (gatewayId.hashCode())
        result = 31 * result + (gatewayName.hashCode())
        result = 31 * result + (gatewayPlatform?.hashCode() ?: 0)
        result = 31 * result + (gatewayVersion?.hashCode() ?: 0)
        result = 31 * result + (lastUpdateDate.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GatewaySummary

        if (creationDate != other.creationDate) return false
        if (gatewayCapabilitySummaries != other.gatewayCapabilitySummaries) return false
        if (gatewayId != other.gatewayId) return false
        if (gatewayName != other.gatewayName) return false
        if (gatewayPlatform != other.gatewayPlatform) return false
        if (gatewayVersion != other.gatewayVersion) return false
        if (lastUpdateDate != other.lastUpdateDate) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.GatewaySummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date the gateway was created, in Unix epoch time.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A list of gateway capability summaries that each contain a namespace and status. Each gateway capability defines data sources for the gateway. To retrieve a capability configuration's definition, use [DescribeGatewayCapabilityConfiguration](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGatewayCapabilityConfiguration.html).
         */
        public var gatewayCapabilitySummaries: List<GatewayCapabilitySummary>? = null
        /**
         * The ID of the gateway device.
         */
        public var gatewayId: kotlin.String? = null
        /**
         * The name of the gateway.
         */
        public var gatewayName: kotlin.String? = null
        /**
         * The gateway's platform configuration. You can only specify one platform type in a gateway.
         *
         * (Legacy only) For Greengrass V1 gateways, specify the `greengrass` parameter with a valid Greengrass group ARN.
         *
         * For Greengrass V2 gateways, specify the `greengrassV2` parameter with a valid core device thing name. If creating a V3 gateway (`gatewayVersion=3`), you must also specify the `coreDeviceOperatingSystem`.
         *
         * For Siemens Industrial Edge gateways, specify the `siemensIE` parameter with a valid IoT Core thing name.
         */
        public var gatewayPlatform: aws.sdk.kotlin.services.iotsitewise.model.GatewayPlatform? = null
        /**
         * The version of the gateway. A value of `3` indicates an MQTT-enabled, V3 gateway, while `2` indicates a Classic streams, V2 gateway.
         */
        public var gatewayVersion: kotlin.String? = null
        /**
         * The date the gateway was last updated, in Unix epoch time.
         */
        public var lastUpdateDate: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.GatewaySummary) : this() {
            this.creationDate = x.creationDate
            this.gatewayCapabilitySummaries = x.gatewayCapabilitySummaries
            this.gatewayId = x.gatewayId
            this.gatewayName = x.gatewayName
            this.gatewayPlatform = x.gatewayPlatform
            this.gatewayVersion = x.gatewayVersion
            this.lastUpdateDate = x.lastUpdateDate
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.GatewaySummary = GatewaySummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.GatewayPlatform] inside the given [block]
         */
        public fun gatewayPlatform(block: aws.sdk.kotlin.services.iotsitewise.model.GatewayPlatform.Builder.() -> kotlin.Unit) {
            this.gatewayPlatform = aws.sdk.kotlin.services.iotsitewise.model.GatewayPlatform.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (creationDate == null) creationDate = Instant.fromEpochSeconds(0)
            if (gatewayId == null) gatewayId = ""
            if (gatewayName == null) gatewayName = ""
            if (lastUpdateDate == null) lastUpdateDate = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
