// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl

public class DisassociateAssetsRequest private constructor(builder: Builder) {
    /**
     * The ID of the parent asset from which to disassociate the child asset. This can be either the actual ID in UUID format, or else `externalId:` followed by the external ID, if it has one. For more information, see [Referencing objects with external IDs](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references) in the *IoT SiteWise User Guide*.
     */
    public val assetId: kotlin.String? = builder.assetId
    /**
     * The ID of the child asset to disassociate. This can be either the actual ID in UUID format, or else `externalId:` followed by the external ID, if it has one. For more information, see [Referencing objects with external IDs](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references) in the *IoT SiteWise User Guide*.
     */
    public val childAssetId: kotlin.String? = builder.childAssetId
    /**
     * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The ID of a hierarchy in the parent asset's model. (This can be either the actual ID in UUID format, or else `externalId:` followed by the external ID, if it has one. For more information, see [Referencing objects with external IDs](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references) in the *IoT SiteWise User Guide*.) Hierarchies allow different groupings of assets to be formed that all come from the same asset model. You can use the hierarchy ID to identify the correct asset to disassociate. For more information, see [Asset hierarchies](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html) in the *IoT SiteWise User Guide*.
     */
    public val hierarchyId: kotlin.String? = builder.hierarchyId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.DisassociateAssetsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DisassociateAssetsRequest(")
        append("assetId=$assetId,")
        append("childAssetId=$childAssetId,")
        append("clientToken=$clientToken,")
        append("hierarchyId=$hierarchyId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assetId?.hashCode() ?: 0
        result = 31 * result + (childAssetId?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (hierarchyId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DisassociateAssetsRequest

        if (assetId != other.assetId) return false
        if (childAssetId != other.childAssetId) return false
        if (clientToken != other.clientToken) return false
        if (hierarchyId != other.hierarchyId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.DisassociateAssetsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the parent asset from which to disassociate the child asset. This can be either the actual ID in UUID format, or else `externalId:` followed by the external ID, if it has one. For more information, see [Referencing objects with external IDs](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references) in the *IoT SiteWise User Guide*.
         */
        public var assetId: kotlin.String? = null
        /**
         * The ID of the child asset to disassociate. This can be either the actual ID in UUID format, or else `externalId:` followed by the external ID, if it has one. For more information, see [Referencing objects with external IDs](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references) in the *IoT SiteWise User Guide*.
         */
        public var childAssetId: kotlin.String? = null
        /**
         * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The ID of a hierarchy in the parent asset's model. (This can be either the actual ID in UUID format, or else `externalId:` followed by the external ID, if it has one. For more information, see [Referencing objects with external IDs](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references) in the *IoT SiteWise User Guide*.) Hierarchies allow different groupings of assets to be formed that all come from the same asset model. You can use the hierarchy ID to identify the correct asset to disassociate. For more information, see [Asset hierarchies](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html) in the *IoT SiteWise User Guide*.
         */
        public var hierarchyId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.DisassociateAssetsRequest) : this() {
            this.assetId = x.assetId
            this.childAssetId = x.childAssetId
            this.clientToken = x.clientToken
            this.hierarchyId = x.hierarchyId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.DisassociateAssetsRequest = DisassociateAssetsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
