// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl

public class DescribeGatewayCapabilityConfigurationResponse private constructor(builder: Builder) {
    /**
     * The JSON document that defines the gateway capability's configuration. For more information, see [Configuring data sources (CLI)](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/configure-sources.html#configure-source-cli) in the *IoT SiteWise User Guide*.
     */
    public val capabilityConfiguration: kotlin.String = requireNotNull(builder.capabilityConfiguration) { "A non-null value must be provided for capabilityConfiguration" }
    /**
     * The namespace of the gateway capability.
     */
    public val capabilityNamespace: kotlin.String = requireNotNull(builder.capabilityNamespace) { "A non-null value must be provided for capabilityNamespace" }
    /**
     * The synchronization status of the gateway capability configuration. The sync status can be one of the following:
     * + `IN_SYNC` - The gateway is running with the latest configuration.
     * + `OUT_OF_SYNC` - The gateway hasn't received the latest configuration.
     * + `SYNC_FAILED` - The gateway rejected the latest configuration.
     * + `UNKNOWN` - The gateway hasn't reported its sync status.
     * + `NOT_APPLICABLE` - The gateway doesn't support this capability. This is most common when integrating partner data sources, because the data integration is handled externally by the partner.
     */
    public val capabilitySyncStatus: aws.sdk.kotlin.services.iotsitewise.model.CapabilitySyncStatus = requireNotNull(builder.capabilitySyncStatus) { "A non-null value must be provided for capabilitySyncStatus" }
    /**
     * The ID of the gateway that defines the capability configuration.
     */
    public val gatewayId: kotlin.String = requireNotNull(builder.gatewayId) { "A non-null value must be provided for gatewayId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.DescribeGatewayCapabilityConfigurationResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeGatewayCapabilityConfigurationResponse(")
        append("capabilityConfiguration=$capabilityConfiguration,")
        append("capabilityNamespace=$capabilityNamespace,")
        append("capabilitySyncStatus=$capabilitySyncStatus,")
        append("gatewayId=$gatewayId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = capabilityConfiguration.hashCode()
        result = 31 * result + (capabilityNamespace.hashCode())
        result = 31 * result + (capabilitySyncStatus.hashCode())
        result = 31 * result + (gatewayId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeGatewayCapabilityConfigurationResponse

        if (capabilityConfiguration != other.capabilityConfiguration) return false
        if (capabilityNamespace != other.capabilityNamespace) return false
        if (capabilitySyncStatus != other.capabilitySyncStatus) return false
        if (gatewayId != other.gatewayId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.DescribeGatewayCapabilityConfigurationResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The JSON document that defines the gateway capability's configuration. For more information, see [Configuring data sources (CLI)](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/configure-sources.html#configure-source-cli) in the *IoT SiteWise User Guide*.
         */
        public var capabilityConfiguration: kotlin.String? = null
        /**
         * The namespace of the gateway capability.
         */
        public var capabilityNamespace: kotlin.String? = null
        /**
         * The synchronization status of the gateway capability configuration. The sync status can be one of the following:
         * + `IN_SYNC` - The gateway is running with the latest configuration.
         * + `OUT_OF_SYNC` - The gateway hasn't received the latest configuration.
         * + `SYNC_FAILED` - The gateway rejected the latest configuration.
         * + `UNKNOWN` - The gateway hasn't reported its sync status.
         * + `NOT_APPLICABLE` - The gateway doesn't support this capability. This is most common when integrating partner data sources, because the data integration is handled externally by the partner.
         */
        public var capabilitySyncStatus: aws.sdk.kotlin.services.iotsitewise.model.CapabilitySyncStatus? = null
        /**
         * The ID of the gateway that defines the capability configuration.
         */
        public var gatewayId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.DescribeGatewayCapabilityConfigurationResponse) : this() {
            this.capabilityConfiguration = x.capabilityConfiguration
            this.capabilityNamespace = x.capabilityNamespace
            this.capabilitySyncStatus = x.capabilitySyncStatus
            this.gatewayId = x.gatewayId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.DescribeGatewayCapabilityConfigurationResponse = DescribeGatewayCapabilityConfigurationResponse(this)

        internal fun correctErrors(): Builder {
            if (capabilityConfiguration == null) capabilityConfiguration = ""
            if (capabilityNamespace == null) capabilityNamespace = ""
            if (capabilitySyncStatus == null) capabilitySyncStatus = CapabilitySyncStatus.SdkUnknown("no value provided")
            if (gatewayId == null) gatewayId = ""
            return this
        }
    }
}
