// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class DescribeComputationModelResponse private constructor(builder: Builder) {
    /**
     * The available actions for this computation model.
     */
    public val actionDefinitions: List<ActionDefinition> = requireNotNull(builder.actionDefinitions) { "A non-null value must be provided for actionDefinitions" }
    /**
     * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the computation model, which has the following format.
     *
     * `arn:${Partition}:iotsitewise:${Region}:${Account}:computation-model/${ComputationModelId}`
     */
    public val computationModelArn: kotlin.String = requireNotNull(builder.computationModelArn) { "A non-null value must be provided for computationModelArn" }
    /**
     * The configuration for the computation model.
     */
    public val computationModelConfiguration: aws.sdk.kotlin.services.iotsitewise.model.ComputationModelConfiguration? = builder.computationModelConfiguration
    /**
     * The model creation date, in Unix epoch time.
     */
    public val computationModelCreationDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.computationModelCreationDate) { "A non-null value must be provided for computationModelCreationDate" }
    /**
     * The data binding for the computation model. Key is a variable name defined in configuration. Value is a `ComputationModelDataBindingValue` referenced by the variable.
     */
    public val computationModelDataBinding: Map<String, ComputationModelDataBindingValue> = requireNotNull(builder.computationModelDataBinding) { "A non-null value must be provided for computationModelDataBinding" }
    /**
     * The description of the computation model.
     */
    public val computationModelDescription: kotlin.String? = builder.computationModelDescription
    /**
     * The ID of the computation model.
     */
    public val computationModelId: kotlin.String = requireNotNull(builder.computationModelId) { "A non-null value must be provided for computationModelId" }
    /**
     * The date the model was last updated, in Unix epoch time.
     */
    public val computationModelLastUpdateDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.computationModelLastUpdateDate) { "A non-null value must be provided for computationModelLastUpdateDate" }
    /**
     * The name of the computation model.
     */
    public val computationModelName: kotlin.String = requireNotNull(builder.computationModelName) { "A non-null value must be provided for computationModelName" }
    /**
     * The current status of the asset model, which contains a state and an error message if any.
     */
    public val computationModelStatus: aws.sdk.kotlin.services.iotsitewise.model.ComputationModelStatus? = builder.computationModelStatus
    /**
     * The version of the computation model.
     */
    public val computationModelVersion: kotlin.String = requireNotNull(builder.computationModelVersion) { "A non-null value must be provided for computationModelVersion" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.DescribeComputationModelResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeComputationModelResponse(")
        append("actionDefinitions=$actionDefinitions,")
        append("computationModelArn=$computationModelArn,")
        append("computationModelConfiguration=$computationModelConfiguration,")
        append("computationModelCreationDate=$computationModelCreationDate,")
        append("computationModelDataBinding=$computationModelDataBinding,")
        append("computationModelDescription=$computationModelDescription,")
        append("computationModelId=$computationModelId,")
        append("computationModelLastUpdateDate=$computationModelLastUpdateDate,")
        append("computationModelName=$computationModelName,")
        append("computationModelStatus=$computationModelStatus,")
        append("computationModelVersion=$computationModelVersion")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actionDefinitions.hashCode()
        result = 31 * result + (computationModelArn.hashCode())
        result = 31 * result + (computationModelConfiguration?.hashCode() ?: 0)
        result = 31 * result + (computationModelCreationDate.hashCode())
        result = 31 * result + (computationModelDataBinding.hashCode())
        result = 31 * result + (computationModelDescription?.hashCode() ?: 0)
        result = 31 * result + (computationModelId.hashCode())
        result = 31 * result + (computationModelLastUpdateDate.hashCode())
        result = 31 * result + (computationModelName.hashCode())
        result = 31 * result + (computationModelStatus?.hashCode() ?: 0)
        result = 31 * result + (computationModelVersion.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeComputationModelResponse

        if (actionDefinitions != other.actionDefinitions) return false
        if (computationModelArn != other.computationModelArn) return false
        if (computationModelConfiguration != other.computationModelConfiguration) return false
        if (computationModelCreationDate != other.computationModelCreationDate) return false
        if (computationModelDataBinding != other.computationModelDataBinding) return false
        if (computationModelDescription != other.computationModelDescription) return false
        if (computationModelId != other.computationModelId) return false
        if (computationModelLastUpdateDate != other.computationModelLastUpdateDate) return false
        if (computationModelName != other.computationModelName) return false
        if (computationModelStatus != other.computationModelStatus) return false
        if (computationModelVersion != other.computationModelVersion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.DescribeComputationModelResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The available actions for this computation model.
         */
        public var actionDefinitions: List<ActionDefinition>? = null
        /**
         * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the computation model, which has the following format.
         *
         * `arn:${Partition}:iotsitewise:${Region}:${Account}:computation-model/${ComputationModelId}`
         */
        public var computationModelArn: kotlin.String? = null
        /**
         * The configuration for the computation model.
         */
        public var computationModelConfiguration: aws.sdk.kotlin.services.iotsitewise.model.ComputationModelConfiguration? = null
        /**
         * The model creation date, in Unix epoch time.
         */
        public var computationModelCreationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The data binding for the computation model. Key is a variable name defined in configuration. Value is a `ComputationModelDataBindingValue` referenced by the variable.
         */
        public var computationModelDataBinding: Map<String, ComputationModelDataBindingValue>? = null
        /**
         * The description of the computation model.
         */
        public var computationModelDescription: kotlin.String? = null
        /**
         * The ID of the computation model.
         */
        public var computationModelId: kotlin.String? = null
        /**
         * The date the model was last updated, in Unix epoch time.
         */
        public var computationModelLastUpdateDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the computation model.
         */
        public var computationModelName: kotlin.String? = null
        /**
         * The current status of the asset model, which contains a state and an error message if any.
         */
        public var computationModelStatus: aws.sdk.kotlin.services.iotsitewise.model.ComputationModelStatus? = null
        /**
         * The version of the computation model.
         */
        public var computationModelVersion: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.DescribeComputationModelResponse) : this() {
            this.actionDefinitions = x.actionDefinitions
            this.computationModelArn = x.computationModelArn
            this.computationModelConfiguration = x.computationModelConfiguration
            this.computationModelCreationDate = x.computationModelCreationDate
            this.computationModelDataBinding = x.computationModelDataBinding
            this.computationModelDescription = x.computationModelDescription
            this.computationModelId = x.computationModelId
            this.computationModelLastUpdateDate = x.computationModelLastUpdateDate
            this.computationModelName = x.computationModelName
            this.computationModelStatus = x.computationModelStatus
            this.computationModelVersion = x.computationModelVersion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.DescribeComputationModelResponse = DescribeComputationModelResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.ComputationModelConfiguration] inside the given [block]
         */
        public fun computationModelConfiguration(block: aws.sdk.kotlin.services.iotsitewise.model.ComputationModelConfiguration.Builder.() -> kotlin.Unit) {
            this.computationModelConfiguration = aws.sdk.kotlin.services.iotsitewise.model.ComputationModelConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.ComputationModelStatus] inside the given [block]
         */
        public fun computationModelStatus(block: aws.sdk.kotlin.services.iotsitewise.model.ComputationModelStatus.Builder.() -> kotlin.Unit) {
            this.computationModelStatus = aws.sdk.kotlin.services.iotsitewise.model.ComputationModelStatus.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (actionDefinitions == null) actionDefinitions = emptyList()
            if (computationModelArn == null) computationModelArn = ""
            if (computationModelCreationDate == null) computationModelCreationDate = Instant.fromEpochSeconds(0)
            if (computationModelDataBinding == null) computationModelDataBinding = emptyMap()
            if (computationModelId == null) computationModelId = ""
            if (computationModelLastUpdateDate == null) computationModelLastUpdateDate = Instant.fromEpochSeconds(0)
            if (computationModelName == null) computationModelName = ""
            if (computationModelVersion == null) computationModelVersion = ""
            return this
        }
    }
}
