// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The summary details for the dataset.
 */
public class DatasetSummary private constructor(builder: Builder) {
    /**
     * The [ARN](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html) of the dataset. The format is `arn:${Partition}:iotsitewise:${Region}:${Account}:dataset/${DatasetId}`.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The dataset creation date, in Unix epoch time.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationDate) { "A non-null value must be provided for creationDate" }
    /**
     * A description about the dataset, and its functionality.
     */
    public val description: kotlin.String = requireNotNull(builder.description) { "A non-null value must be provided for description" }
    /**
     * The ID of the dataset.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The date the dataset was last updated, in Unix epoch time.
     */
    public val lastUpdateDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastUpdateDate) { "A non-null value must be provided for lastUpdateDate" }
    /**
     * The name of the dataset.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The status of the dataset. This contains the state and any error messages. The state is `ACTIVE` when ready to use.
     */
    public val status: aws.sdk.kotlin.services.iotsitewise.model.DatasetStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.DatasetSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DatasetSummary(")
        append("arn=$arn,")
        append("creationDate=$creationDate,")
        append("description=$description,")
        append("id=$id,")
        append("lastUpdateDate=$lastUpdateDate,")
        append("name=$name,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (creationDate.hashCode())
        result = 31 * result + (description.hashCode())
        result = 31 * result + (id.hashCode())
        result = 31 * result + (lastUpdateDate.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DatasetSummary

        if (arn != other.arn) return false
        if (creationDate != other.creationDate) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (lastUpdateDate != other.lastUpdateDate) return false
        if (name != other.name) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.DatasetSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The [ARN](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html) of the dataset. The format is `arn:${Partition}:iotsitewise:${Region}:${Account}:dataset/${DatasetId}`.
         */
        public var arn: kotlin.String? = null
        /**
         * The dataset creation date, in Unix epoch time.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A description about the dataset, and its functionality.
         */
        public var description: kotlin.String? = null
        /**
         * The ID of the dataset.
         */
        public var id: kotlin.String? = null
        /**
         * The date the dataset was last updated, in Unix epoch time.
         */
        public var lastUpdateDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the dataset.
         */
        public var name: kotlin.String? = null
        /**
         * The status of the dataset. This contains the state and any error messages. The state is `ACTIVE` when ready to use.
         */
        public var status: aws.sdk.kotlin.services.iotsitewise.model.DatasetStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.DatasetSummary) : this() {
            this.arn = x.arn
            this.creationDate = x.creationDate
            this.description = x.description
            this.id = x.id
            this.lastUpdateDate = x.lastUpdateDate
            this.name = x.name
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.DatasetSummary = DatasetSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.DatasetStatus] inside the given [block]
         */
        public fun status(block: aws.sdk.kotlin.services.iotsitewise.model.DatasetStatus.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.iotsitewise.model.DatasetStatus.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (creationDate == null) creationDate = Instant.fromEpochSeconds(0)
            if (description == null) description = ""
            if (id == null) id = ""
            if (lastUpdateDate == null) lastUpdateDate = Instant.fromEpochSeconds(0)
            if (name == null) name = ""
            return this
        }
    }
}
