// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreatePortalResponse private constructor(builder: Builder) {
    /**
     * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the portal, which has the following format.
     *
     * `arn:${Partition}:iotsitewise:${Region}:${Account}:portal/${PortalId}`
     */
    public val portalArn: kotlin.String = requireNotNull(builder.portalArn) { "A non-null value must be provided for portalArn" }
    /**
     * The ID of the created portal.
     */
    public val portalId: kotlin.String = requireNotNull(builder.portalId) { "A non-null value must be provided for portalId" }
    /**
     * The URL for the IoT SiteWise Monitor portal. You can use this URL to access portals that use IAM Identity Center for authentication. For portals that use IAM for authentication, you must use the IoT SiteWise console to get a URL that you can use to access the portal.
     */
    public val portalStartUrl: kotlin.String = requireNotNull(builder.portalStartUrl) { "A non-null value must be provided for portalStartUrl" }
    /**
     * The status of the portal, which contains a state (`CREATING` after successfully calling this operation) and any error message.
     */
    public val portalStatus: aws.sdk.kotlin.services.iotsitewise.model.PortalStatus? = builder.portalStatus
    /**
     * The associated IAM Identity Center application ID, if the portal uses IAM Identity Center.
     */
    public val ssoApplicationId: kotlin.String = requireNotNull(builder.ssoApplicationId) { "A non-null value must be provided for ssoApplicationId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.CreatePortalResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreatePortalResponse(")
        append("portalArn=$portalArn,")
        append("portalId=$portalId,")
        append("portalStartUrl=$portalStartUrl,")
        append("portalStatus=$portalStatus,")
        append("ssoApplicationId=$ssoApplicationId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = portalArn.hashCode()
        result = 31 * result + (portalId.hashCode())
        result = 31 * result + (portalStartUrl.hashCode())
        result = 31 * result + (portalStatus?.hashCode() ?: 0)
        result = 31 * result + (ssoApplicationId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreatePortalResponse

        if (portalArn != other.portalArn) return false
        if (portalId != other.portalId) return false
        if (portalStartUrl != other.portalStartUrl) return false
        if (portalStatus != other.portalStatus) return false
        if (ssoApplicationId != other.ssoApplicationId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.CreatePortalResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the portal, which has the following format.
         *
         * `arn:${Partition}:iotsitewise:${Region}:${Account}:portal/${PortalId}`
         */
        public var portalArn: kotlin.String? = null
        /**
         * The ID of the created portal.
         */
        public var portalId: kotlin.String? = null
        /**
         * The URL for the IoT SiteWise Monitor portal. You can use this URL to access portals that use IAM Identity Center for authentication. For portals that use IAM for authentication, you must use the IoT SiteWise console to get a URL that you can use to access the portal.
         */
        public var portalStartUrl: kotlin.String? = null
        /**
         * The status of the portal, which contains a state (`CREATING` after successfully calling this operation) and any error message.
         */
        public var portalStatus: aws.sdk.kotlin.services.iotsitewise.model.PortalStatus? = null
        /**
         * The associated IAM Identity Center application ID, if the portal uses IAM Identity Center.
         */
        public var ssoApplicationId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.CreatePortalResponse) : this() {
            this.portalArn = x.portalArn
            this.portalId = x.portalId
            this.portalStartUrl = x.portalStartUrl
            this.portalStatus = x.portalStatus
            this.ssoApplicationId = x.ssoApplicationId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.CreatePortalResponse = CreatePortalResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.PortalStatus] inside the given [block]
         */
        public fun portalStatus(block: aws.sdk.kotlin.services.iotsitewise.model.PortalStatus.Builder.() -> kotlin.Unit) {
            this.portalStatus = aws.sdk.kotlin.services.iotsitewise.model.PortalStatus.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (portalArn == null) portalArn = ""
            if (portalId == null) portalId = ""
            if (portalStartUrl == null) portalStartUrl = ""
            if (ssoApplicationId == null) ssoApplicationId = ""
            return this
        }
    }
}
