// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateAssetResponse private constructor(builder: Builder) {
    /**
     * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the asset, which has the following format.
     *
     * `arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}`
     */
    public val assetArn: kotlin.String = requireNotNull(builder.assetArn) { "A non-null value must be provided for assetArn" }
    /**
     * The ID of the asset, in UUID format. This ID uniquely identifies the asset within IoT SiteWise and can be used with other IoT SiteWise API operations.
     */
    public val assetId: kotlin.String = requireNotNull(builder.assetId) { "A non-null value must be provided for assetId" }
    /**
     * The status of the asset, which contains a state (`CREATING` after successfully calling this operation) and any error message.
     */
    public val assetStatus: aws.sdk.kotlin.services.iotsitewise.model.AssetStatus? = builder.assetStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.CreateAssetResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAssetResponse(")
        append("assetArn=$assetArn,")
        append("assetId=$assetId,")
        append("assetStatus=$assetStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assetArn.hashCode()
        result = 31 * result + (assetId.hashCode())
        result = 31 * result + (assetStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAssetResponse

        if (assetArn != other.assetArn) return false
        if (assetId != other.assetId) return false
        if (assetStatus != other.assetStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.CreateAssetResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the asset, which has the following format.
         *
         * `arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}`
         */
        public var assetArn: kotlin.String? = null
        /**
         * The ID of the asset, in UUID format. This ID uniquely identifies the asset within IoT SiteWise and can be used with other IoT SiteWise API operations.
         */
        public var assetId: kotlin.String? = null
        /**
         * The status of the asset, which contains a state (`CREATING` after successfully calling this operation) and any error message.
         */
        public var assetStatus: aws.sdk.kotlin.services.iotsitewise.model.AssetStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.CreateAssetResponse) : this() {
            this.assetArn = x.assetArn
            this.assetId = x.assetId
            this.assetStatus = x.assetStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.CreateAssetResponse = CreateAssetResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.AssetStatus] inside the given [block]
         */
        public fun assetStatus(block: aws.sdk.kotlin.services.iotsitewise.model.AssetStatus.Builder.() -> kotlin.Unit) {
            this.assetStatus = aws.sdk.kotlin.services.iotsitewise.model.AssetStatus.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (assetArn == null) assetArn = ""
            if (assetId == null) assetId = ""
            return this
        }
    }
}
