// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateAssetModelResponse private constructor(builder: Builder) {
    /**
     * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the asset model, which has the following format.
     *
     * `arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}`
     */
    public val assetModelArn: kotlin.String = requireNotNull(builder.assetModelArn) { "A non-null value must be provided for assetModelArn" }
    /**
     * The ID of the asset model, in UUID format. You can use this ID when you call other IoT SiteWise API operations.
     */
    public val assetModelId: kotlin.String = requireNotNull(builder.assetModelId) { "A non-null value must be provided for assetModelId" }
    /**
     * The status of the asset model, which contains a state (`CREATING` after successfully calling this operation) and any error message.
     */
    public val assetModelStatus: aws.sdk.kotlin.services.iotsitewise.model.AssetModelStatus? = builder.assetModelStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.CreateAssetModelResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAssetModelResponse(")
        append("assetModelArn=$assetModelArn,")
        append("assetModelId=$assetModelId,")
        append("assetModelStatus=$assetModelStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assetModelArn.hashCode()
        result = 31 * result + (assetModelId.hashCode())
        result = 31 * result + (assetModelStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAssetModelResponse

        if (assetModelArn != other.assetModelArn) return false
        if (assetModelId != other.assetModelId) return false
        if (assetModelStatus != other.assetModelStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.CreateAssetModelResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the asset model, which has the following format.
         *
         * `arn:${Partition}:iotsitewise:${Region}:${Account}:asset-model/${AssetModelId}`
         */
        public var assetModelArn: kotlin.String? = null
        /**
         * The ID of the asset model, in UUID format. You can use this ID when you call other IoT SiteWise API operations.
         */
        public var assetModelId: kotlin.String? = null
        /**
         * The status of the asset model, which contains a state (`CREATING` after successfully calling this operation) and any error message.
         */
        public var assetModelStatus: aws.sdk.kotlin.services.iotsitewise.model.AssetModelStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.CreateAssetModelResponse) : this() {
            this.assetModelArn = x.assetModelArn
            this.assetModelId = x.assetModelId
            this.assetModelStatus = x.assetModelStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.CreateAssetModelResponse = CreateAssetModelResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.AssetModelStatus] inside the given [block]
         */
        public fun assetModelStatus(block: aws.sdk.kotlin.services.iotsitewise.model.AssetModelStatus.Builder.() -> kotlin.Unit) {
            this.assetModelStatus = aws.sdk.kotlin.services.iotsitewise.model.AssetModelStatus.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (assetModelArn == null) assetModelArn = ""
            if (assetModelId == null) assetModelId = ""
            return this
        }
    }
}
