// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateAssetModelRequest private constructor(builder: Builder) {
    /**
     * The composite models that are part of this asset model. It groups properties (such as attributes, measurements, transforms, and metrics) and child composite models that model parts of your industrial equipment. Each composite model has a type that defines the properties that the composite model supports. Use composite models to define alarms on this asset model.
     *
     * When creating custom composite models, you need to use [CreateAssetModelCompositeModel](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModelCompositeModel.html). For more information, see [Creating custom composite models (Components)](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-custom-composite-models.html) in the *IoT SiteWise User Guide*.
     */
    public val assetModelCompositeModels: List<AssetModelCompositeModelDefinition>? = builder.assetModelCompositeModels
    /**
     * A description for the asset model.
     */
    public val assetModelDescription: kotlin.String? = builder.assetModelDescription
    /**
     * An external ID to assign to the asset model. The external ID must be unique within your Amazon Web Services account. For more information, see [Using external IDs](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids) in the *IoT SiteWise User Guide*.
     */
    public val assetModelExternalId: kotlin.String? = builder.assetModelExternalId
    /**
     * The hierarchy definitions of the asset model. Each hierarchy specifies an asset model whose assets can be children of any other assets created from this asset model. For more information, see [Asset hierarchies](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html) in the *IoT SiteWise User Guide*.
     *
     * You can specify up to 10 hierarchies per asset model. For more information, see [Quotas](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html) in the *IoT SiteWise User Guide*.
     */
    public val assetModelHierarchies: List<AssetModelHierarchyDefinition>? = builder.assetModelHierarchies
    /**
     * The ID to assign to the asset model, if desired. IoT SiteWise automatically generates a unique ID for you, so this parameter is never required. However, if you prefer to supply your own ID instead, you can specify it here in UUID format. If you specify your own ID, it must be globally unique.
     */
    public val assetModelId: kotlin.String? = builder.assetModelId
    /**
     * A unique name for the asset model.
     */
    public val assetModelName: kotlin.String? = builder.assetModelName
    /**
     * The property definitions of the asset model. For more information, see [Asset properties](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html) in the *IoT SiteWise User Guide*.
     *
     * You can specify up to 200 properties per asset model. For more information, see [Quotas](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html) in the *IoT SiteWise User Guide*.
     */
    public val assetModelProperties: List<AssetModelPropertyDefinition>? = builder.assetModelProperties
    /**
     * The type of asset model.
     * + **ASSET_MODEL** – (default) An asset model that you can use to create assets. Can't be included as a component in another asset model.
     * + **COMPONENT_MODEL** – A reusable component that you can include in the composite models of other asset models. You can't create assets directly from this type of asset model.
     */
    public val assetModelType: aws.sdk.kotlin.services.iotsitewise.model.AssetModelType? = builder.assetModelType
    /**
     * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * A list of key-value pairs that contain metadata for the asset model. For more information, see [Tagging your IoT SiteWise resources](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html) in the *IoT SiteWise User Guide*.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.CreateAssetModelRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAssetModelRequest(")
        append("assetModelCompositeModels=$assetModelCompositeModels,")
        append("assetModelDescription=$assetModelDescription,")
        append("assetModelExternalId=$assetModelExternalId,")
        append("assetModelHierarchies=$assetModelHierarchies,")
        append("assetModelId=$assetModelId,")
        append("assetModelName=$assetModelName,")
        append("assetModelProperties=$assetModelProperties,")
        append("assetModelType=$assetModelType,")
        append("clientToken=$clientToken,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assetModelCompositeModels?.hashCode() ?: 0
        result = 31 * result + (assetModelDescription?.hashCode() ?: 0)
        result = 31 * result + (assetModelExternalId?.hashCode() ?: 0)
        result = 31 * result + (assetModelHierarchies?.hashCode() ?: 0)
        result = 31 * result + (assetModelId?.hashCode() ?: 0)
        result = 31 * result + (assetModelName?.hashCode() ?: 0)
        result = 31 * result + (assetModelProperties?.hashCode() ?: 0)
        result = 31 * result + (assetModelType?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAssetModelRequest

        if (assetModelCompositeModels != other.assetModelCompositeModels) return false
        if (assetModelDescription != other.assetModelDescription) return false
        if (assetModelExternalId != other.assetModelExternalId) return false
        if (assetModelHierarchies != other.assetModelHierarchies) return false
        if (assetModelId != other.assetModelId) return false
        if (assetModelName != other.assetModelName) return false
        if (assetModelProperties != other.assetModelProperties) return false
        if (assetModelType != other.assetModelType) return false
        if (clientToken != other.clientToken) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.CreateAssetModelRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The composite models that are part of this asset model. It groups properties (such as attributes, measurements, transforms, and metrics) and child composite models that model parts of your industrial equipment. Each composite model has a type that defines the properties that the composite model supports. Use composite models to define alarms on this asset model.
         *
         * When creating custom composite models, you need to use [CreateAssetModelCompositeModel](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModelCompositeModel.html). For more information, see [Creating custom composite models (Components)](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-custom-composite-models.html) in the *IoT SiteWise User Guide*.
         */
        public var assetModelCompositeModels: List<AssetModelCompositeModelDefinition>? = null
        /**
         * A description for the asset model.
         */
        public var assetModelDescription: kotlin.String? = null
        /**
         * An external ID to assign to the asset model. The external ID must be unique within your Amazon Web Services account. For more information, see [Using external IDs](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids) in the *IoT SiteWise User Guide*.
         */
        public var assetModelExternalId: kotlin.String? = null
        /**
         * The hierarchy definitions of the asset model. Each hierarchy specifies an asset model whose assets can be children of any other assets created from this asset model. For more information, see [Asset hierarchies](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html) in the *IoT SiteWise User Guide*.
         *
         * You can specify up to 10 hierarchies per asset model. For more information, see [Quotas](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html) in the *IoT SiteWise User Guide*.
         */
        public var assetModelHierarchies: List<AssetModelHierarchyDefinition>? = null
        /**
         * The ID to assign to the asset model, if desired. IoT SiteWise automatically generates a unique ID for you, so this parameter is never required. However, if you prefer to supply your own ID instead, you can specify it here in UUID format. If you specify your own ID, it must be globally unique.
         */
        public var assetModelId: kotlin.String? = null
        /**
         * A unique name for the asset model.
         */
        public var assetModelName: kotlin.String? = null
        /**
         * The property definitions of the asset model. For more information, see [Asset properties](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html) in the *IoT SiteWise User Guide*.
         *
         * You can specify up to 200 properties per asset model. For more information, see [Quotas](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html) in the *IoT SiteWise User Guide*.
         */
        public var assetModelProperties: List<AssetModelPropertyDefinition>? = null
        /**
         * The type of asset model.
         * + **ASSET_MODEL** – (default) An asset model that you can use to create assets. Can't be included as a component in another asset model.
         * + **COMPONENT_MODEL** – A reusable component that you can include in the composite models of other asset models. You can't create assets directly from this type of asset model.
         */
        public var assetModelType: aws.sdk.kotlin.services.iotsitewise.model.AssetModelType? = null
        /**
         * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse this client token if a new idempotent request is required.
         */
        public var clientToken: kotlin.String? = null
        /**
         * A list of key-value pairs that contain metadata for the asset model. For more information, see [Tagging your IoT SiteWise resources](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html) in the *IoT SiteWise User Guide*.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.CreateAssetModelRequest) : this() {
            this.assetModelCompositeModels = x.assetModelCompositeModels
            this.assetModelDescription = x.assetModelDescription
            this.assetModelExternalId = x.assetModelExternalId
            this.assetModelHierarchies = x.assetModelHierarchies
            this.assetModelId = x.assetModelId
            this.assetModelName = x.assetModelName
            this.assetModelProperties = x.assetModelProperties
            this.assetModelType = x.assetModelType
            this.clientToken = x.clientToken
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.CreateAssetModelRequest = CreateAssetModelRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
