// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains a summary of a computation model.
 */
public class ComputationModelSummary private constructor(builder: Builder) {
    /**
     * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the computation model, which has the following format.
     *
     * `arn:${Partition}:iotsitewise:${Region}:${Account}:computation-model/${ComputationModelId}`
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The model creation date, in Unix epoch time.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationDate) { "A non-null value must be provided for creationDate" }
    /**
     * The description of the computation model.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The ID of the computation model.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The time the model was last updated, in Unix epoch time.
     */
    public val lastUpdateDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastUpdateDate) { "A non-null value must be provided for lastUpdateDate" }
    /**
     * The name of the computation model.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The current status of the computation model.
     */
    public val status: aws.sdk.kotlin.services.iotsitewise.model.ComputationModelStatus? = builder.status
    /**
     * The type of the computation model.
     */
    public val type: aws.sdk.kotlin.services.iotsitewise.model.ComputationModelType = requireNotNull(builder.type) { "A non-null value must be provided for type" }
    /**
     * The version of the computation model.
     */
    public val version: kotlin.String = requireNotNull(builder.version) { "A non-null value must be provided for version" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.ComputationModelSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ComputationModelSummary(")
        append("arn=$arn,")
        append("creationDate=$creationDate,")
        append("description=$description,")
        append("id=$id,")
        append("lastUpdateDate=$lastUpdateDate,")
        append("name=$name,")
        append("status=$status,")
        append("type=$type,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (creationDate.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id.hashCode())
        result = 31 * result + (lastUpdateDate.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (type.hashCode())
        result = 31 * result + (version.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ComputationModelSummary

        if (arn != other.arn) return false
        if (creationDate != other.creationDate) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (lastUpdateDate != other.lastUpdateDate) return false
        if (name != other.name) return false
        if (status != other.status) return false
        if (type != other.type) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.ComputationModelSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the computation model, which has the following format.
         *
         * `arn:${Partition}:iotsitewise:${Region}:${Account}:computation-model/${ComputationModelId}`
         */
        public var arn: kotlin.String? = null
        /**
         * The model creation date, in Unix epoch time.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the computation model.
         */
        public var description: kotlin.String? = null
        /**
         * The ID of the computation model.
         */
        public var id: kotlin.String? = null
        /**
         * The time the model was last updated, in Unix epoch time.
         */
        public var lastUpdateDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the computation model.
         */
        public var name: kotlin.String? = null
        /**
         * The current status of the computation model.
         */
        public var status: aws.sdk.kotlin.services.iotsitewise.model.ComputationModelStatus? = null
        /**
         * The type of the computation model.
         */
        public var type: aws.sdk.kotlin.services.iotsitewise.model.ComputationModelType? = null
        /**
         * The version of the computation model.
         */
        public var version: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.ComputationModelSummary) : this() {
            this.arn = x.arn
            this.creationDate = x.creationDate
            this.description = x.description
            this.id = x.id
            this.lastUpdateDate = x.lastUpdateDate
            this.name = x.name
            this.status = x.status
            this.type = x.type
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.ComputationModelSummary = ComputationModelSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.ComputationModelStatus] inside the given [block]
         */
        public fun status(block: aws.sdk.kotlin.services.iotsitewise.model.ComputationModelStatus.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.iotsitewise.model.ComputationModelStatus.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (creationDate == null) creationDate = Instant.fromEpochSeconds(0)
            if (id == null) id = ""
            if (lastUpdateDate == null) lastUpdateDate = Instant.fromEpochSeconds(0)
            if (name == null) name = ""
            if (type == null) type = ComputationModelType.SdkUnknown("no value provided")
            if (version == null) version = ""
            return this
        }
    }
}
