// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains information about a composite model property on an asset.
 */
public class CompositeModelProperty private constructor(builder: Builder) {
    /**
     * Contains asset property information.
     */
    public val assetProperty: aws.sdk.kotlin.services.iotsitewise.model.Property? = builder.assetProperty
    /**
     * The external ID of the composite model that contains the property. For more information, see [Using external IDs](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids) in the *IoT SiteWise User Guide*.
     */
    public val externalId: kotlin.String? = builder.externalId
    /**
     * The ID of the composite model that contains the property.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The name of the property.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The type of the composite model that defines this property.
     */
    public val type: kotlin.String = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.CompositeModelProperty = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CompositeModelProperty(")
        append("assetProperty=$assetProperty,")
        append("externalId=$externalId,")
        append("id=$id,")
        append("name=$name,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assetProperty?.hashCode() ?: 0
        result = 31 * result + (externalId?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CompositeModelProperty

        if (assetProperty != other.assetProperty) return false
        if (externalId != other.externalId) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.CompositeModelProperty = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Contains asset property information.
         */
        public var assetProperty: aws.sdk.kotlin.services.iotsitewise.model.Property? = null
        /**
         * The external ID of the composite model that contains the property. For more information, see [Using external IDs](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids) in the *IoT SiteWise User Guide*.
         */
        public var externalId: kotlin.String? = null
        /**
         * The ID of the composite model that contains the property.
         */
        public var id: kotlin.String? = null
        /**
         * The name of the property.
         */
        public var name: kotlin.String? = null
        /**
         * The type of the composite model that defines this property.
         */
        public var type: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.CompositeModelProperty) : this() {
            this.assetProperty = x.assetProperty
            this.externalId = x.externalId
            this.id = x.id
            this.name = x.name
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.CompositeModelProperty = CompositeModelProperty(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.Property] inside the given [block]
         */
        public fun assetProperty(block: aws.sdk.kotlin.services.iotsitewise.model.Property.Builder.() -> kotlin.Unit) {
            this.assetProperty = aws.sdk.kotlin.services.iotsitewise.model.Property.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            if (type == null) type = ""
            return this
        }
    }
}
