// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information for an asset property historical value entry that is associated with the [BatchGetAssetPropertyValueHistory](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyValue.html) API.
 *
 * To identify an asset property, you must specify one of the following:
 * + The `assetId` and `propertyId` of an asset property.
 * + A `propertyAlias`, which is a data stream alias (for example, `/company/windfarm/3/turbine/7/temperature`). To define an asset property's alias, see [UpdateAssetProperty](https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_UpdateAssetProperty.html).
 */
public class BatchGetAssetPropertyValueHistoryEntry private constructor(builder: Builder) {
    /**
     * The ID of the asset in which the asset property was created.
     */
    public val assetId: kotlin.String? = builder.assetId
    /**
     * The inclusive end of the range from which to query historical data, expressed in seconds in Unix epoch time.
     */
    public val endDate: aws.smithy.kotlin.runtime.time.Instant? = builder.endDate
    /**
     * The ID of the entry.
     */
    public val entryId: kotlin.String = requireNotNull(builder.entryId) { "A non-null value must be provided for entryId" }
    /**
     * The alias that identifies the property, such as an OPC-UA server data stream path (for example, `/company/windfarm/3/turbine/7/temperature`). For more information, see [Mapping industrial data streams to asset properties](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html) in the *IoT SiteWise User Guide*.
     */
    public val propertyAlias: kotlin.String? = builder.propertyAlias
    /**
     * The ID of the asset property, in UUID format.
     */
    public val propertyId: kotlin.String? = builder.propertyId
    /**
     * The quality by which to filter asset data.
     */
    public val qualities: List<Quality>? = builder.qualities
    /**
     * The exclusive start of the range from which to query historical data, expressed in seconds in Unix epoch time.
     */
    public val startDate: aws.smithy.kotlin.runtime.time.Instant? = builder.startDate
    /**
     * The chronological sorting order of the requested information.
     *
     * Default: `ASCENDING`
     */
    public val timeOrdering: aws.sdk.kotlin.services.iotsitewise.model.TimeOrdering? = builder.timeOrdering

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BatchGetAssetPropertyValueHistoryEntry(")
        append("assetId=$assetId,")
        append("endDate=$endDate,")
        append("entryId=$entryId,")
        append("propertyAlias=$propertyAlias,")
        append("propertyId=$propertyId,")
        append("qualities=$qualities,")
        append("startDate=$startDate,")
        append("timeOrdering=$timeOrdering")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assetId?.hashCode() ?: 0
        result = 31 * result + (endDate?.hashCode() ?: 0)
        result = 31 * result + (entryId.hashCode())
        result = 31 * result + (propertyAlias?.hashCode() ?: 0)
        result = 31 * result + (propertyId?.hashCode() ?: 0)
        result = 31 * result + (qualities?.hashCode() ?: 0)
        result = 31 * result + (startDate?.hashCode() ?: 0)
        result = 31 * result + (timeOrdering?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BatchGetAssetPropertyValueHistoryEntry

        if (assetId != other.assetId) return false
        if (endDate != other.endDate) return false
        if (entryId != other.entryId) return false
        if (propertyAlias != other.propertyAlias) return false
        if (propertyId != other.propertyId) return false
        if (qualities != other.qualities) return false
        if (startDate != other.startDate) return false
        if (timeOrdering != other.timeOrdering) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryEntry = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the asset in which the asset property was created.
         */
        public var assetId: kotlin.String? = null
        /**
         * The inclusive end of the range from which to query historical data, expressed in seconds in Unix epoch time.
         */
        public var endDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ID of the entry.
         */
        public var entryId: kotlin.String? = null
        /**
         * The alias that identifies the property, such as an OPC-UA server data stream path (for example, `/company/windfarm/3/turbine/7/temperature`). For more information, see [Mapping industrial data streams to asset properties](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/connect-data-streams.html) in the *IoT SiteWise User Guide*.
         */
        public var propertyAlias: kotlin.String? = null
        /**
         * The ID of the asset property, in UUID format.
         */
        public var propertyId: kotlin.String? = null
        /**
         * The quality by which to filter asset data.
         */
        public var qualities: List<Quality>? = null
        /**
         * The exclusive start of the range from which to query historical data, expressed in seconds in Unix epoch time.
         */
        public var startDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The chronological sorting order of the requested information.
         *
         * Default: `ASCENDING`
         */
        public var timeOrdering: aws.sdk.kotlin.services.iotsitewise.model.TimeOrdering? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryEntry) : this() {
            this.assetId = x.assetId
            this.endDate = x.endDate
            this.entryId = x.entryId
            this.propertyAlias = x.propertyAlias
            this.propertyId = x.propertyId
            this.qualities = x.qualities
            this.startDate = x.startDate
            this.timeOrdering = x.timeOrdering
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryEntry = BatchGetAssetPropertyValueHistoryEntry(this)

        internal fun correctErrors(): Builder {
            if (entryId == null) entryId = ""
            return this
        }
    }
}
