// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains a summary of an associated asset.
 */
public class AssociatedAssetsSummary private constructor(builder: Builder) {
    /**
     * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the asset, which has the following format.
     *
     * `arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}`
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The ID of the asset model used to create the asset.
     */
    public val assetModelId: kotlin.String = requireNotNull(builder.assetModelId) { "A non-null value must be provided for assetModelId" }
    /**
     * The date the asset was created, in Unix epoch time.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationDate) { "A non-null value must be provided for creationDate" }
    /**
     * A description for the asset.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The external ID of the asset. For more information, see [Using external IDs](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids) in the *IoT SiteWise User Guide*.
     */
    public val externalId: kotlin.String? = builder.externalId
    /**
     * A list of asset hierarchies that each contain a `hierarchyId`. A hierarchy specifies allowed parent/child asset relationships.
     */
    public val hierarchies: List<AssetHierarchy> = requireNotNull(builder.hierarchies) { "A non-null value must be provided for hierarchies" }
    /**
     * The ID of the asset, in UUID format.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The date the asset was last updated, in Unix epoch time.
     */
    public val lastUpdateDate: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.lastUpdateDate) { "A non-null value must be provided for lastUpdateDate" }
    /**
     * The name of the asset.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The current status of the asset.
     */
    public val status: aws.sdk.kotlin.services.iotsitewise.model.AssetStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.AssociatedAssetsSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssociatedAssetsSummary(")
        append("arn=$arn,")
        append("assetModelId=$assetModelId,")
        append("creationDate=$creationDate,")
        append("description=$description,")
        append("externalId=$externalId,")
        append("hierarchies=$hierarchies,")
        append("id=$id,")
        append("lastUpdateDate=$lastUpdateDate,")
        append("name=$name,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (assetModelId.hashCode())
        result = 31 * result + (creationDate.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (externalId?.hashCode() ?: 0)
        result = 31 * result + (hierarchies.hashCode())
        result = 31 * result + (id.hashCode())
        result = 31 * result + (lastUpdateDate.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssociatedAssetsSummary

        if (arn != other.arn) return false
        if (assetModelId != other.assetModelId) return false
        if (creationDate != other.creationDate) return false
        if (description != other.description) return false
        if (externalId != other.externalId) return false
        if (hierarchies != other.hierarchies) return false
        if (id != other.id) return false
        if (lastUpdateDate != other.lastUpdateDate) return false
        if (name != other.name) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.AssociatedAssetsSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The [ARN](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) of the asset, which has the following format.
         *
         * `arn:${Partition}:iotsitewise:${Region}:${Account}:asset/${AssetId}`
         */
        public var arn: kotlin.String? = null
        /**
         * The ID of the asset model used to create the asset.
         */
        public var assetModelId: kotlin.String? = null
        /**
         * The date the asset was created, in Unix epoch time.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A description for the asset.
         */
        public var description: kotlin.String? = null
        /**
         * The external ID of the asset. For more information, see [Using external IDs](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids) in the *IoT SiteWise User Guide*.
         */
        public var externalId: kotlin.String? = null
        /**
         * A list of asset hierarchies that each contain a `hierarchyId`. A hierarchy specifies allowed parent/child asset relationships.
         */
        public var hierarchies: List<AssetHierarchy>? = null
        /**
         * The ID of the asset, in UUID format.
         */
        public var id: kotlin.String? = null
        /**
         * The date the asset was last updated, in Unix epoch time.
         */
        public var lastUpdateDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the asset.
         */
        public var name: kotlin.String? = null
        /**
         * The current status of the asset.
         */
        public var status: aws.sdk.kotlin.services.iotsitewise.model.AssetStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.AssociatedAssetsSummary) : this() {
            this.arn = x.arn
            this.assetModelId = x.assetModelId
            this.creationDate = x.creationDate
            this.description = x.description
            this.externalId = x.externalId
            this.hierarchies = x.hierarchies
            this.id = x.id
            this.lastUpdateDate = x.lastUpdateDate
            this.name = x.name
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.AssociatedAssetsSummary = AssociatedAssetsSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.AssetStatus] inside the given [block]
         */
        public fun status(block: aws.sdk.kotlin.services.iotsitewise.model.AssetStatus.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.iotsitewise.model.AssetStatus.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (assetModelId == null) assetModelId = ""
            if (creationDate == null) creationDate = Instant.fromEpochSeconds(0)
            if (hierarchies == null) hierarchies = emptyList()
            if (id == null) id = ""
            if (lastUpdateDate == null) lastUpdateDate = Instant.fromEpochSeconds(0)
            if (name == null) name = ""
            return this
        }
    }
}
