// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A filter used to match data bindings based on a specific asset property. This filter helps identify all computation models referencing a particular property of an asset in their data bindings.
 */
public class AssetPropertyBindingValueFilter private constructor(builder: Builder) {
    /**
     * The ID of the asset containing the property to filter by. This identifies the specific asset instance containing the property of interest.
     */
    public val assetId: kotlin.String = requireNotNull(builder.assetId) { "A non-null value must be provided for assetId" }
    /**
     * The ID of the property within the asset to filter by. Only data bindings referencing this specific property of the specified asset are matched.
     */
    public val propertyId: kotlin.String = requireNotNull(builder.propertyId) { "A non-null value must be provided for propertyId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.AssetPropertyBindingValueFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssetPropertyBindingValueFilter(")
        append("assetId=$assetId,")
        append("propertyId=$propertyId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assetId.hashCode()
        result = 31 * result + (propertyId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssetPropertyBindingValueFilter

        if (assetId != other.assetId) return false
        if (propertyId != other.propertyId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.AssetPropertyBindingValueFilter = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the asset containing the property to filter by. This identifies the specific asset instance containing the property of interest.
         */
        public var assetId: kotlin.String? = null
        /**
         * The ID of the property within the asset to filter by. Only data bindings referencing this specific property of the specified asset are matched.
         */
        public var propertyId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.AssetPropertyBindingValueFilter) : this() {
            this.assetId = x.assetId
            this.propertyId = x.propertyId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.AssetPropertyBindingValueFilter = AssetPropertyBindingValueFilter(this)

        internal fun correctErrors(): Builder {
            if (assetId == null) assetId = ""
            if (propertyId == null) propertyId = ""
            return this
        }
    }
}
