// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents a data binding value referencing a specific asset property. It's used to bind computation model variables to actual asset property values for processing.
 */
public class AssetPropertyBindingValue private constructor(builder: Builder) {
    /**
     * The ID of the asset containing the property. This identifies the specific asset instance's property value used in the computation model.
     */
    public val assetId: kotlin.String = requireNotNull(builder.assetId) { "A non-null value must be provided for assetId" }
    /**
     * The ID of the property within the asset. This identifies the specific property's value used in the computation model.
     */
    public val propertyId: kotlin.String = requireNotNull(builder.propertyId) { "A non-null value must be provided for propertyId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.AssetPropertyBindingValue = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssetPropertyBindingValue(")
        append("assetId=$assetId,")
        append("propertyId=$propertyId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assetId.hashCode()
        result = 31 * result + (propertyId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssetPropertyBindingValue

        if (assetId != other.assetId) return false
        if (propertyId != other.propertyId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.AssetPropertyBindingValue = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the asset containing the property. This identifies the specific asset instance's property value used in the computation model.
         */
        public var assetId: kotlin.String? = null
        /**
         * The ID of the property within the asset. This identifies the specific property's value used in the computation model.
         */
        public var propertyId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.AssetPropertyBindingValue) : this() {
            this.assetId = x.assetId
            this.propertyId = x.propertyId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.AssetPropertyBindingValue = AssetPropertyBindingValue(this)

        internal fun correctErrors(): Builder {
            if (assetId == null) assetId = ""
            if (propertyId == null) propertyId = ""
            return this
        }
    }
}
