// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains a summary of a property associated with a model. This includes information about which interfaces the property belongs to, if any.
 */
public class AssetModelPropertySummary private constructor(builder: Builder) {
    /**
     * The ID of the composite model that contains the asset model property.
     */
    public val assetModelCompositeModelId: kotlin.String? = builder.assetModelCompositeModelId
    /**
     * The data type of the property.
     */
    public val dataType: aws.sdk.kotlin.services.iotsitewise.model.PropertyDataType = requireNotNull(builder.dataType) { "A non-null value must be provided for dataType" }
    /**
     * The data type of the structure for this property. This parameter exists on properties that have the `STRUCT` data type.
     */
    public val dataTypeSpec: kotlin.String? = builder.dataTypeSpec
    /**
     * The external ID of the property. For more information, see [Using external IDs](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids) in the *IoT SiteWise User Guide*.
     */
    public val externalId: kotlin.String? = builder.externalId
    /**
     * The ID of the property.
     */
    public val id: kotlin.String? = builder.id
    /**
     * A list of interface summaries that describe which interfaces this property belongs to, including the interface asset model ID and the corresponding property ID in the interface.
     */
    public val interfaceSummaries: List<InterfaceSummary>? = builder.interfaceSummaries
    /**
     * The name of the property.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The structured path to the property from the root of the asset model.
     */
    public val path: List<AssetModelPropertyPathSegment>? = builder.path
    /**
     * Contains a property type, which can be one of `attribute`, `measurement`, `metric`, or `transform`.
     */
    public val type: aws.sdk.kotlin.services.iotsitewise.model.PropertyType? = builder.type
    /**
     * The unit (such as `Newtons` or `RPM`) of the property.
     */
    public val unit: kotlin.String? = builder.unit

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.AssetModelPropertySummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssetModelPropertySummary(")
        append("assetModelCompositeModelId=$assetModelCompositeModelId,")
        append("dataType=$dataType,")
        append("dataTypeSpec=$dataTypeSpec,")
        append("externalId=$externalId,")
        append("id=$id,")
        append("interfaceSummaries=$interfaceSummaries,")
        append("name=$name,")
        append("path=$path,")
        append("type=$type,")
        append("unit=$unit")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assetModelCompositeModelId?.hashCode() ?: 0
        result = 31 * result + (dataType.hashCode())
        result = 31 * result + (dataTypeSpec?.hashCode() ?: 0)
        result = 31 * result + (externalId?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (interfaceSummaries?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (path?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (unit?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssetModelPropertySummary

        if (assetModelCompositeModelId != other.assetModelCompositeModelId) return false
        if (dataType != other.dataType) return false
        if (dataTypeSpec != other.dataTypeSpec) return false
        if (externalId != other.externalId) return false
        if (id != other.id) return false
        if (interfaceSummaries != other.interfaceSummaries) return false
        if (name != other.name) return false
        if (path != other.path) return false
        if (type != other.type) return false
        if (unit != other.unit) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.AssetModelPropertySummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the composite model that contains the asset model property.
         */
        public var assetModelCompositeModelId: kotlin.String? = null
        /**
         * The data type of the property.
         */
        public var dataType: aws.sdk.kotlin.services.iotsitewise.model.PropertyDataType? = null
        /**
         * The data type of the structure for this property. This parameter exists on properties that have the `STRUCT` data type.
         */
        public var dataTypeSpec: kotlin.String? = null
        /**
         * The external ID of the property. For more information, see [Using external IDs](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids) in the *IoT SiteWise User Guide*.
         */
        public var externalId: kotlin.String? = null
        /**
         * The ID of the property.
         */
        public var id: kotlin.String? = null
        /**
         * A list of interface summaries that describe which interfaces this property belongs to, including the interface asset model ID and the corresponding property ID in the interface.
         */
        public var interfaceSummaries: List<InterfaceSummary>? = null
        /**
         * The name of the property.
         */
        public var name: kotlin.String? = null
        /**
         * The structured path to the property from the root of the asset model.
         */
        public var path: List<AssetModelPropertyPathSegment>? = null
        /**
         * Contains a property type, which can be one of `attribute`, `measurement`, `metric`, or `transform`.
         */
        public var type: aws.sdk.kotlin.services.iotsitewise.model.PropertyType? = null
        /**
         * The unit (such as `Newtons` or `RPM`) of the property.
         */
        public var unit: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.AssetModelPropertySummary) : this() {
            this.assetModelCompositeModelId = x.assetModelCompositeModelId
            this.dataType = x.dataType
            this.dataTypeSpec = x.dataTypeSpec
            this.externalId = x.externalId
            this.id = x.id
            this.interfaceSummaries = x.interfaceSummaries
            this.name = x.name
            this.path = x.path
            this.type = x.type
            this.unit = x.unit
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.AssetModelPropertySummary = AssetModelPropertySummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.PropertyType] inside the given [block]
         */
        public fun type(block: aws.sdk.kotlin.services.iotsitewise.model.PropertyType.Builder.() -> kotlin.Unit) {
            this.type = aws.sdk.kotlin.services.iotsitewise.model.PropertyType.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (dataType == null) dataType = PropertyDataType.SdkUnknown("no value provided")
            if (name == null) name = ""
            return this
        }
    }
}
