// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A filter used to match data bindings based on a specific asset model property. This filter identifies all computation models that reference a particular property of an asset model in their data bindings.
 */
public class AssetModelPropertyBindingValueFilter private constructor(builder: Builder) {
    /**
     * The ID of the asset model containing the filter property. This identifies the specific asset model that contains the property of interest.
     */
    public val assetModelId: kotlin.String = requireNotNull(builder.assetModelId) { "A non-null value must be provided for assetModelId" }
    /**
     * The ID of the property within the asset model to filter by. Only data bindings referencing this specific property of the specified asset model are matched.
     */
    public val propertyId: kotlin.String = requireNotNull(builder.propertyId) { "A non-null value must be provided for propertyId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.AssetModelPropertyBindingValueFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssetModelPropertyBindingValueFilter(")
        append("assetModelId=$assetModelId,")
        append("propertyId=$propertyId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assetModelId.hashCode()
        result = 31 * result + (propertyId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssetModelPropertyBindingValueFilter

        if (assetModelId != other.assetModelId) return false
        if (propertyId != other.propertyId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.AssetModelPropertyBindingValueFilter = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the asset model containing the filter property. This identifies the specific asset model that contains the property of interest.
         */
        public var assetModelId: kotlin.String? = null
        /**
         * The ID of the property within the asset model to filter by. Only data bindings referencing this specific property of the specified asset model are matched.
         */
        public var propertyId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.AssetModelPropertyBindingValueFilter) : this() {
            this.assetModelId = x.assetModelId
            this.propertyId = x.propertyId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.AssetModelPropertyBindingValueFilter = AssetModelPropertyBindingValueFilter(this)

        internal fun correctErrors(): Builder {
            if (assetModelId == null) assetModelId = ""
            if (propertyId == null) propertyId = ""
            return this
        }
    }
}
