// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains information about a composite model in an asset. This object contains the asset's properties that you define in the composite model.
 */
public class AssetCompositeModel private constructor(builder: Builder) {
    /**
     * The description of the composite model.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The external ID of the asset composite model. For more information, see [Using external IDs](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids) in the *IoT SiteWise User Guide*.
     */
    public val externalId: kotlin.String? = builder.externalId
    /**
     * The ID of the asset composite model.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The name of the composite model.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The asset properties that this composite model defines.
     */
    public val properties: List<AssetProperty> = requireNotNull(builder.properties) { "A non-null value must be provided for properties" }
    /**
     * The type of the composite model. For alarm composite models, this type is `AWS/ALARM`.
     */
    public val type: kotlin.String = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.AssetCompositeModel = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssetCompositeModel(")
        append("description=$description,")
        append("externalId=$externalId,")
        append("id=$id,")
        append("name=$name,")
        append("properties=$properties,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (externalId?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (properties.hashCode())
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssetCompositeModel

        if (description != other.description) return false
        if (externalId != other.externalId) return false
        if (id != other.id) return false
        if (name != other.name) return false
        if (properties != other.properties) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.AssetCompositeModel = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The description of the composite model.
         */
        public var description: kotlin.String? = null
        /**
         * The external ID of the asset composite model. For more information, see [Using external IDs](https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids) in the *IoT SiteWise User Guide*.
         */
        public var externalId: kotlin.String? = null
        /**
         * The ID of the asset composite model.
         */
        public var id: kotlin.String? = null
        /**
         * The name of the composite model.
         */
        public var name: kotlin.String? = null
        /**
         * The asset properties that this composite model defines.
         */
        public var properties: List<AssetProperty>? = null
        /**
         * The type of the composite model. For alarm composite models, this type is `AWS/ALARM`.
         */
        public var type: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.AssetCompositeModel) : this() {
            this.description = x.description
            this.externalId = x.externalId
            this.id = x.id
            this.name = x.name
            this.properties = x.properties
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.AssetCompositeModel = AssetCompositeModel(this)

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            if (properties == null) properties = emptyList()
            if (type == null) type = ""
            return this
        }
    }
}
