// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsitewise.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains an access policy that defines an identity's access to an IoT SiteWise Monitor resource.
 */
public class AccessPolicySummary private constructor(builder: Builder) {
    /**
     * The date the access policy was created, in Unix epoch time.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * The ID of the access policy.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The identity (an IAM Identity Center user, an IAM Identity Center group, or an IAM user).
     */
    public val identity: aws.sdk.kotlin.services.iotsitewise.model.Identity? = builder.identity
    /**
     * The date the access policy was last updated, in Unix epoch time.
     */
    public val lastUpdateDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdateDate
    /**
     * The permissions for the access policy. Note that a project `ADMINISTRATOR` is also known as a project owner.
     */
    public val permission: aws.sdk.kotlin.services.iotsitewise.model.Permission = requireNotNull(builder.permission) { "A non-null value must be provided for permission" }
    /**
     * The IoT SiteWise Monitor resource (a portal or project).
     */
    public val resource: aws.sdk.kotlin.services.iotsitewise.model.Resource? = builder.resource

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotsitewise.model.AccessPolicySummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AccessPolicySummary(")
        append("creationDate=$creationDate,")
        append("id=$id,")
        append("identity=$identity,")
        append("lastUpdateDate=$lastUpdateDate,")
        append("permission=$permission,")
        append("resource=$resource")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = creationDate?.hashCode() ?: 0
        result = 31 * result + (id.hashCode())
        result = 31 * result + (identity?.hashCode() ?: 0)
        result = 31 * result + (lastUpdateDate?.hashCode() ?: 0)
        result = 31 * result + (permission.hashCode())
        result = 31 * result + (resource?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AccessPolicySummary

        if (creationDate != other.creationDate) return false
        if (id != other.id) return false
        if (identity != other.identity) return false
        if (lastUpdateDate != other.lastUpdateDate) return false
        if (permission != other.permission) return false
        if (resource != other.resource) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotsitewise.model.AccessPolicySummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date the access policy was created, in Unix epoch time.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ID of the access policy.
         */
        public var id: kotlin.String? = null
        /**
         * The identity (an IAM Identity Center user, an IAM Identity Center group, or an IAM user).
         */
        public var identity: aws.sdk.kotlin.services.iotsitewise.model.Identity? = null
        /**
         * The date the access policy was last updated, in Unix epoch time.
         */
        public var lastUpdateDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The permissions for the access policy. Note that a project `ADMINISTRATOR` is also known as a project owner.
         */
        public var permission: aws.sdk.kotlin.services.iotsitewise.model.Permission? = null
        /**
         * The IoT SiteWise Monitor resource (a portal or project).
         */
        public var resource: aws.sdk.kotlin.services.iotsitewise.model.Resource? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotsitewise.model.AccessPolicySummary) : this() {
            this.creationDate = x.creationDate
            this.id = x.id
            this.identity = x.identity
            this.lastUpdateDate = x.lastUpdateDate
            this.permission = x.permission
            this.resource = x.resource
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotsitewise.model.AccessPolicySummary = AccessPolicySummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.Identity] inside the given [block]
         */
        public fun identity(block: aws.sdk.kotlin.services.iotsitewise.model.Identity.Builder.() -> kotlin.Unit) {
            this.identity = aws.sdk.kotlin.services.iotsitewise.model.Identity.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iotsitewise.model.Resource] inside the given [block]
         */
        public fun resource(block: aws.sdk.kotlin.services.iotsitewise.model.Resource.Builder.() -> kotlin.Unit) {
            this.resource = aws.sdk.kotlin.services.iotsitewise.model.Resource.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (id == null) id = ""
            if (permission == null) permission = Permission.SdkUnknown("no value provided")
            return this
        }
    }
}
