// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsecuretunneling.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iotsecuretunneling.model.IoTSecureTunnelingException
import aws.sdk.kotlin.services.iotsecuretunneling.model.OpenTunnelResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class OpenTunnelOperationDeserializer: HttpDeserialize<OpenTunnelResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): OpenTunnelResponse {
        if (!response.status.isSuccess()) {
            throwOpenTunnelError(context, response)
        }
        val builder = OpenTunnelResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeOpenTunnelOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeOpenTunnelOperationBody(builder: OpenTunnelResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DESTINATIONACCESSTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("destinationAccessToken"))
    val SOURCEACCESSTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("sourceAccessToken"))
    val TUNNELARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("tunnelArn"))
    val TUNNELID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("tunnelId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DESTINATIONACCESSTOKEN_DESCRIPTOR)
        field(SOURCEACCESSTOKEN_DESCRIPTOR)
        field(TUNNELARN_DESCRIPTOR)
        field(TUNNELID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DESTINATIONACCESSTOKEN_DESCRIPTOR.index -> builder.destinationAccessToken = deserializeString()
                SOURCEACCESSTOKEN_DESCRIPTOR.index -> builder.sourceAccessToken = deserializeString()
                TUNNELARN_DESCRIPTOR.index -> builder.tunnelArn = deserializeString()
                TUNNELID_DESCRIPTOR.index -> builder.tunnelId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwOpenTunnelError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IoTSecureTunnelingException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "LimitExceededException" -> LimitExceededExceptionDeserializer()
        else -> throw IoTSecureTunnelingException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
