// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotsecuretunneling

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.client.AwsClientConfig
import aws.sdk.kotlin.runtime.config.AwsClientConfigLoadOptions
import aws.sdk.kotlin.runtime.config.fromEnvironment
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.services.iotsecuretunneling.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.iotsecuretunneling.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucketOptions

/**
 * <fullname>AWS IoT Secure Tunneling</fullname>
 * AWS IoT Secure Tunnling enables you to create remote connections to devices
 * deployed in the field.
 * For more information about how AWS IoT Secure Tunneling works, see <a href="https://docs.aws.amazon.com/iot/latest/developerguide/secure-tunneling.html">AWS IoT Secure Tunneling.
 */
interface IoTSecureTunnelingClient : SdkClient {

    override val serviceName: String
        get() = "IoTSecureTunneling"
    /**
     * IoTSecureTunnelingClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(sharedConfig: AwsClientConfig? = null, block: Config.Builder.() -> Unit = {}): IoTSecureTunnelingClient {
            val config = Config.Builder().apply {
                region = sharedConfig?.region
                credentialsProvider = sharedConfig?.credentialsProvider
                sdkLogMode = sharedConfig?.sdkLogMode ?: SdkLogMode.Default
            }.apply(block).build()
            return DefaultIoTSecureTunnelingClient(config)
        }

        operator fun invoke(config: Config): IoTSecureTunnelingClient = DefaultIoTSecureTunnelingClient(config)

        /**
         * Construct a [IoTSecureTunnelingClient] by resolving the configuration from the current environment.
         * NOTE: If you are using multiple AWS service clients you may wish to share the configuration among them
         * by constructing a [aws.sdk.kotlin.runtime.client.AwsClientConfig] and passing it to each client at construction.
         */
        suspend fun fromEnvironment(block: AwsClientConfigLoadOptions.() -> Unit = {}): IoTSecureTunnelingClient {
            val sharedConfig = AwsClientConfig.fromEnvironment(block)
            return IoTSecureTunnelingClient(sharedConfig)
        }
    }

    class Config private constructor(builder: Builder): AwsClientConfig, HttpClientConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Closes a tunnel identified by the unique tunnel id. When a CloseTunnel
     * request is received, we close the WebSocket connections between the client and proxy
     * server so no data can be transmitted.
     */
    suspend fun closeTunnel(input: CloseTunnelRequest): CloseTunnelResponse

    /**
     * Closes a tunnel identified by the unique tunnel id. When a CloseTunnel
     * request is received, we close the WebSocket connections between the client and proxy
     * server so no data can be transmitted.
     */
    suspend fun closeTunnel(block: CloseTunnelRequest.Builder.() -> Unit) = closeTunnel(CloseTunnelRequest.Builder().apply(block).build())

    /**
     * Gets information about a tunnel identified by the unique tunnel id.
     */
    suspend fun describeTunnel(input: DescribeTunnelRequest): DescribeTunnelResponse

    /**
     * Gets information about a tunnel identified by the unique tunnel id.
     */
    suspend fun describeTunnel(block: DescribeTunnelRequest.Builder.() -> Unit) = describeTunnel(DescribeTunnelRequest.Builder().apply(block).build())

    /**
     * Lists the tags for the specified resource.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists the tags for the specified resource.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

    /**
     * List all tunnels for an AWS account. Tunnels are listed by creation time in
     * descending order, newer tunnels will be listed before older tunnels.
     */
    suspend fun listTunnels(input: ListTunnelsRequest): ListTunnelsResponse

    /**
     * List all tunnels for an AWS account. Tunnels are listed by creation time in
     * descending order, newer tunnels will be listed before older tunnels.
     */
    suspend fun listTunnels(block: ListTunnelsRequest.Builder.() -> Unit) = listTunnels(ListTunnelsRequest.Builder().apply(block).build())

    /**
     * Creates a new tunnel, and returns two client access tokens for clients to use to
     * connect to the AWS IoT Secure Tunneling proxy server.
     */
    suspend fun openTunnel(input: OpenTunnelRequest): OpenTunnelResponse

    /**
     * Creates a new tunnel, and returns two client access tokens for clients to use to
     * connect to the AWS IoT Secure Tunneling proxy server.
     */
    suspend fun openTunnel(block: OpenTunnelRequest.Builder.() -> Unit) = openTunnel(OpenTunnelRequest.Builder().apply(block).build())

    /**
     * A resource tag.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * A resource tag.
     */
    suspend fun tagResource(block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

    /**
     * Removes a tag from a resource.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes a tag from a resource.
     */
    suspend fun untagResource(block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())
}
