// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotroborunner.transform

import aws.sdk.kotlin.services.iotroborunner.model.DestinationState
import aws.sdk.kotlin.services.iotroborunner.model.IotRoboRunnerException
import aws.sdk.kotlin.services.iotroborunner.model.UpdateDestinationResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class UpdateDestinationOperationDeserializer: HttpDeserialize<UpdateDestinationResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateDestinationResponse {
        if (!response.status.isSuccess()) {
            throwUpdateDestinationError(context, response)
        }
        val builder = UpdateDestinationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateDestinationOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdateDestinationError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IotRoboRunnerException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IotRoboRunnerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateDestinationOperationBody(builder: UpdateDestinationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ADDITIONALFIXEDPROPERTIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("additionalFixedProperties"))
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("arn"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val STATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("state"))
    val UPDATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("updatedAt"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ADDITIONALFIXEDPROPERTIES_DESCRIPTOR)
        field(ARN_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(STATE_DESCRIPTOR)
        field(UPDATEDAT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ADDITIONALFIXEDPROPERTIES_DESCRIPTOR.index -> builder.additionalFixedProperties = deserializeString()
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                STATE_DESCRIPTOR.index -> builder.state = deserializeString().let { DestinationState.fromValue(it) }
                UPDATEDAT_DESCRIPTOR.index -> builder.updatedAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
