// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotroborunner.transform

import aws.sdk.kotlin.services.iotroborunner.model.GetWorkerFleetResponse
import aws.sdk.kotlin.services.iotroborunner.model.IotRoboRunnerException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetWorkerFleetOperationDeserializer: HttpDeserialize<GetWorkerFleetResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetWorkerFleetResponse {
        if (!response.status.isSuccess()) {
            throwGetWorkerFleetError(context, response)
        }
        val builder = GetWorkerFleetResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetWorkerFleetOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetWorkerFleetError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IotRoboRunnerException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IotRoboRunnerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetWorkerFleetOperationBody(builder: GetWorkerFleetResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ADDITIONALFIXEDPROPERTIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("additionalFixedProperties"))
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("arn"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdAt"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val SITE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("site"))
    val UPDATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("updatedAt"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ADDITIONALFIXEDPROPERTIES_DESCRIPTOR)
        field(ARN_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(SITE_DESCRIPTOR)
        field(UPDATEDAT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ADDITIONALFIXEDPROPERTIES_DESCRIPTOR.index -> builder.additionalFixedProperties = deserializeString()
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                SITE_DESCRIPTOR.index -> builder.site = deserializeString()
                UPDATEDAT_DESCRIPTOR.index -> builder.updatedAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
