// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotroborunner

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.iotroborunner.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.iotroborunner.endpoints.EndpointParameters
import aws.sdk.kotlin.services.iotroborunner.endpoints.EndpointProvider
import aws.sdk.kotlin.services.iotroborunner.model.CreateDestinationRequest
import aws.sdk.kotlin.services.iotroborunner.model.CreateDestinationResponse
import aws.sdk.kotlin.services.iotroborunner.model.CreateSiteRequest
import aws.sdk.kotlin.services.iotroborunner.model.CreateSiteResponse
import aws.sdk.kotlin.services.iotroborunner.model.CreateWorkerFleetRequest
import aws.sdk.kotlin.services.iotroborunner.model.CreateWorkerFleetResponse
import aws.sdk.kotlin.services.iotroborunner.model.CreateWorkerRequest
import aws.sdk.kotlin.services.iotroborunner.model.CreateWorkerResponse
import aws.sdk.kotlin.services.iotroborunner.model.DeleteDestinationRequest
import aws.sdk.kotlin.services.iotroborunner.model.DeleteDestinationResponse
import aws.sdk.kotlin.services.iotroborunner.model.DeleteSiteRequest
import aws.sdk.kotlin.services.iotroborunner.model.DeleteSiteResponse
import aws.sdk.kotlin.services.iotroborunner.model.DeleteWorkerFleetRequest
import aws.sdk.kotlin.services.iotroborunner.model.DeleteWorkerFleetResponse
import aws.sdk.kotlin.services.iotroborunner.model.DeleteWorkerRequest
import aws.sdk.kotlin.services.iotroborunner.model.DeleteWorkerResponse
import aws.sdk.kotlin.services.iotroborunner.model.GetDestinationRequest
import aws.sdk.kotlin.services.iotroborunner.model.GetDestinationResponse
import aws.sdk.kotlin.services.iotroborunner.model.GetSiteRequest
import aws.sdk.kotlin.services.iotroborunner.model.GetSiteResponse
import aws.sdk.kotlin.services.iotroborunner.model.GetWorkerFleetRequest
import aws.sdk.kotlin.services.iotroborunner.model.GetWorkerFleetResponse
import aws.sdk.kotlin.services.iotroborunner.model.GetWorkerRequest
import aws.sdk.kotlin.services.iotroborunner.model.GetWorkerResponse
import aws.sdk.kotlin.services.iotroborunner.model.ListDestinationsRequest
import aws.sdk.kotlin.services.iotroborunner.model.ListDestinationsResponse
import aws.sdk.kotlin.services.iotroborunner.model.ListSitesRequest
import aws.sdk.kotlin.services.iotroborunner.model.ListSitesResponse
import aws.sdk.kotlin.services.iotroborunner.model.ListWorkerFleetsRequest
import aws.sdk.kotlin.services.iotroborunner.model.ListWorkerFleetsResponse
import aws.sdk.kotlin.services.iotroborunner.model.ListWorkersRequest
import aws.sdk.kotlin.services.iotroborunner.model.ListWorkersResponse
import aws.sdk.kotlin.services.iotroborunner.model.UpdateDestinationRequest
import aws.sdk.kotlin.services.iotroborunner.model.UpdateDestinationResponse
import aws.sdk.kotlin.services.iotroborunner.model.UpdateSiteRequest
import aws.sdk.kotlin.services.iotroborunner.model.UpdateSiteResponse
import aws.sdk.kotlin.services.iotroborunner.model.UpdateWorkerFleetRequest
import aws.sdk.kotlin.services.iotroborunner.model.UpdateWorkerFleetResponse
import aws.sdk.kotlin.services.iotroborunner.model.UpdateWorkerRequest
import aws.sdk.kotlin.services.iotroborunner.model.UpdateWorkerResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.internal.manage
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.tracing.DefaultTracer
import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbe
import aws.smithy.kotlin.runtime.tracing.Tracer
import aws.smithy.kotlin.runtime.tracing.TracingClientConfig
import kotlin.collections.List
import kotlin.jvm.JvmStatic

/**
 * An example service, deployed with the Octane Service creator, which will echo the string
 */
public interface IotRoboRunnerClient : SdkClient {
    /**
     * IotRoboRunnerClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, IotRoboRunnerClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, IotRoboRunnerClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): IotRoboRunnerClient = DefaultIotRoboRunnerClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig, TracingClientConfig {
        override val clientName: String = builder.clientName
        override val httpClientEngine: HttpClientEngine = builder.httpClientEngine ?: DefaultHttpEngine().manage()
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region).manage()
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsDefaultRetryPolicy
        override val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        override val tracer: Tracer = builder.tracer ?: DefaultTracer(LoggingTraceProbe, clientName)
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            httpClientEngine = this@Config.httpClientEngine
            region = this@Config.region
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            sdkLogMode = this@Config.sdkLogMode
            signer = this@Config.signer
            tracer = this@Config.tracer
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
        }

        public class Builder : AwsSdkClientConfig.Builder, HttpClientConfig.Builder, IdempotencyTokenConfig.Builder, SdkClientConfig.Builder<Config>, TracingClientConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "IoT RoboRunner"

            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            override var httpClientEngine: HttpClientEngine? = null

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: EndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            override var retryStrategy: RetryStrategy? = null

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default

            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            /**
             * The tracer that is responsible for creating trace spans and wiring them up to a tracing backend (e.g.,
             * a trace probe). By default, this will create a standard tracer that uses the service name for the root
             * trace span and delegates to a logging trace probe (i.e.,
             * `DefaultTracer(LoggingTraceProbe, "<service-name>")`).
             */
            override var tracer: Tracer? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Grants permission to create a destination
     */
    public suspend fun createDestination(input: CreateDestinationRequest): CreateDestinationResponse

    /**
     * Grants permission to create a site
     */
    public suspend fun createSite(input: CreateSiteRequest): CreateSiteResponse

    /**
     * Grants permission to create a worker
     */
    public suspend fun createWorker(input: CreateWorkerRequest): CreateWorkerResponse

    /**
     * Grants permission to create a worker fleet
     */
    public suspend fun createWorkerFleet(input: CreateWorkerFleetRequest): CreateWorkerFleetResponse

    /**
     * Grants permission to delete a destination
     */
    public suspend fun deleteDestination(input: DeleteDestinationRequest): DeleteDestinationResponse

    /**
     * Grants permission to delete a site
     */
    public suspend fun deleteSite(input: DeleteSiteRequest): DeleteSiteResponse

    /**
     * Grants permission to delete a worker
     */
    public suspend fun deleteWorker(input: DeleteWorkerRequest): DeleteWorkerResponse

    /**
     * Grants permission to delete a worker fleet
     */
    public suspend fun deleteWorkerFleet(input: DeleteWorkerFleetRequest): DeleteWorkerFleetResponse

    /**
     * Grants permission to get a destination
     */
    public suspend fun getDestination(input: GetDestinationRequest): GetDestinationResponse

    /**
     * Grants permission to get a site
     */
    public suspend fun getSite(input: GetSiteRequest): GetSiteResponse

    /**
     * Grants permission to get a worker
     */
    public suspend fun getWorker(input: GetWorkerRequest): GetWorkerResponse

    /**
     * Grants permission to get a worker fleet
     */
    public suspend fun getWorkerFleet(input: GetWorkerFleetRequest): GetWorkerFleetResponse

    /**
     * Grants permission to list destinations
     */
    public suspend fun listDestinations(input: ListDestinationsRequest): ListDestinationsResponse

    /**
     * Grants permission to list sites
     */
    public suspend fun listSites(input: ListSitesRequest = ListSitesRequest {}): ListSitesResponse

    /**
     * Grants permission to list worker fleets
     */
    public suspend fun listWorkerFleets(input: ListWorkerFleetsRequest): ListWorkerFleetsResponse

    /**
     * Grants permission to list workers
     */
    public suspend fun listWorkers(input: ListWorkersRequest): ListWorkersResponse

    /**
     * Grants permission to update a destination
     */
    public suspend fun updateDestination(input: UpdateDestinationRequest): UpdateDestinationResponse

    /**
     * Grants permission to update a site
     */
    public suspend fun updateSite(input: UpdateSiteRequest): UpdateSiteResponse

    /**
     * Grants permission to update a worker
     */
    public suspend fun updateWorker(input: UpdateWorkerRequest): UpdateWorkerResponse

    /**
     * Grants permission to update a worker fleet
     */
    public suspend fun updateWorkerFleet(input: UpdateWorkerFleetRequest): UpdateWorkerFleetResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun IotRoboRunnerClient.withConfig(block: IotRoboRunnerClient.Config.Builder.() -> Unit): IotRoboRunnerClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultIotRoboRunnerClient(newConfig)
}

/**
 * Grants permission to create a destination
 */
public suspend inline fun IotRoboRunnerClient.createDestination(crossinline block: CreateDestinationRequest.Builder.() -> Unit): CreateDestinationResponse = createDestination(CreateDestinationRequest.Builder().apply(block).build())

/**
 * Grants permission to create a site
 */
public suspend inline fun IotRoboRunnerClient.createSite(crossinline block: CreateSiteRequest.Builder.() -> Unit): CreateSiteResponse = createSite(CreateSiteRequest.Builder().apply(block).build())

/**
 * Grants permission to create a worker
 */
public suspend inline fun IotRoboRunnerClient.createWorker(crossinline block: CreateWorkerRequest.Builder.() -> Unit): CreateWorkerResponse = createWorker(CreateWorkerRequest.Builder().apply(block).build())

/**
 * Grants permission to create a worker fleet
 */
public suspend inline fun IotRoboRunnerClient.createWorkerFleet(crossinline block: CreateWorkerFleetRequest.Builder.() -> Unit): CreateWorkerFleetResponse = createWorkerFleet(CreateWorkerFleetRequest.Builder().apply(block).build())

/**
 * Grants permission to delete a destination
 */
public suspend inline fun IotRoboRunnerClient.deleteDestination(crossinline block: DeleteDestinationRequest.Builder.() -> Unit): DeleteDestinationResponse = deleteDestination(DeleteDestinationRequest.Builder().apply(block).build())

/**
 * Grants permission to delete a site
 */
public suspend inline fun IotRoboRunnerClient.deleteSite(crossinline block: DeleteSiteRequest.Builder.() -> Unit): DeleteSiteResponse = deleteSite(DeleteSiteRequest.Builder().apply(block).build())

/**
 * Grants permission to delete a worker
 */
public suspend inline fun IotRoboRunnerClient.deleteWorker(crossinline block: DeleteWorkerRequest.Builder.() -> Unit): DeleteWorkerResponse = deleteWorker(DeleteWorkerRequest.Builder().apply(block).build())

/**
 * Grants permission to delete a worker fleet
 */
public suspend inline fun IotRoboRunnerClient.deleteWorkerFleet(crossinline block: DeleteWorkerFleetRequest.Builder.() -> Unit): DeleteWorkerFleetResponse = deleteWorkerFleet(DeleteWorkerFleetRequest.Builder().apply(block).build())

/**
 * Grants permission to get a destination
 */
public suspend inline fun IotRoboRunnerClient.getDestination(crossinline block: GetDestinationRequest.Builder.() -> Unit): GetDestinationResponse = getDestination(GetDestinationRequest.Builder().apply(block).build())

/**
 * Grants permission to get a site
 */
public suspend inline fun IotRoboRunnerClient.getSite(crossinline block: GetSiteRequest.Builder.() -> Unit): GetSiteResponse = getSite(GetSiteRequest.Builder().apply(block).build())

/**
 * Grants permission to get a worker
 */
public suspend inline fun IotRoboRunnerClient.getWorker(crossinline block: GetWorkerRequest.Builder.() -> Unit): GetWorkerResponse = getWorker(GetWorkerRequest.Builder().apply(block).build())

/**
 * Grants permission to get a worker fleet
 */
public suspend inline fun IotRoboRunnerClient.getWorkerFleet(crossinline block: GetWorkerFleetRequest.Builder.() -> Unit): GetWorkerFleetResponse = getWorkerFleet(GetWorkerFleetRequest.Builder().apply(block).build())

/**
 * Grants permission to list destinations
 */
public suspend inline fun IotRoboRunnerClient.listDestinations(crossinline block: ListDestinationsRequest.Builder.() -> Unit): ListDestinationsResponse = listDestinations(ListDestinationsRequest.Builder().apply(block).build())

/**
 * Grants permission to list sites
 */
public suspend inline fun IotRoboRunnerClient.listSites(crossinline block: ListSitesRequest.Builder.() -> Unit): ListSitesResponse = listSites(ListSitesRequest.Builder().apply(block).build())

/**
 * Grants permission to list worker fleets
 */
public suspend inline fun IotRoboRunnerClient.listWorkerFleets(crossinline block: ListWorkerFleetsRequest.Builder.() -> Unit): ListWorkerFleetsResponse = listWorkerFleets(ListWorkerFleetsRequest.Builder().apply(block).build())

/**
 * Grants permission to list workers
 */
public suspend inline fun IotRoboRunnerClient.listWorkers(crossinline block: ListWorkersRequest.Builder.() -> Unit): ListWorkersResponse = listWorkers(ListWorkersRequest.Builder().apply(block).build())

/**
 * Grants permission to update a destination
 */
public suspend inline fun IotRoboRunnerClient.updateDestination(crossinline block: UpdateDestinationRequest.Builder.() -> Unit): UpdateDestinationResponse = updateDestination(UpdateDestinationRequest.Builder().apply(block).build())

/**
 * Grants permission to update a site
 */
public suspend inline fun IotRoboRunnerClient.updateSite(crossinline block: UpdateSiteRequest.Builder.() -> Unit): UpdateSiteResponse = updateSite(UpdateSiteRequest.Builder().apply(block).build())

/**
 * Grants permission to update a worker
 */
public suspend inline fun IotRoboRunnerClient.updateWorker(crossinline block: UpdateWorkerRequest.Builder.() -> Unit): UpdateWorkerResponse = updateWorker(UpdateWorkerRequest.Builder().apply(block).build())

/**
 * Grants permission to update a worker fleet
 */
public suspend inline fun IotRoboRunnerClient.updateWorkerFleet(crossinline block: UpdateWorkerFleetRequest.Builder.() -> Unit): UpdateWorkerFleetResponse = updateWorkerFleet(UpdateWorkerFleetRequest.Builder().apply(block).build())
