// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotroborunner

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.iotroborunner.endpoints.internal.ResolveEndpoint
import aws.sdk.kotlin.services.iotroborunner.endpoints.internal.bindAwsBuiltins
import aws.sdk.kotlin.services.iotroborunner.model.*
import aws.sdk.kotlin.services.iotroborunner.model.CreateDestinationRequest
import aws.sdk.kotlin.services.iotroborunner.model.CreateSiteRequest
import aws.sdk.kotlin.services.iotroborunner.model.CreateWorkerFleetRequest
import aws.sdk.kotlin.services.iotroborunner.model.CreateWorkerRequest
import aws.sdk.kotlin.services.iotroborunner.model.DeleteDestinationRequest
import aws.sdk.kotlin.services.iotroborunner.model.DeleteSiteRequest
import aws.sdk.kotlin.services.iotroborunner.model.DeleteWorkerFleetRequest
import aws.sdk.kotlin.services.iotroborunner.model.DeleteWorkerRequest
import aws.sdk.kotlin.services.iotroborunner.model.GetDestinationRequest
import aws.sdk.kotlin.services.iotroborunner.model.GetSiteRequest
import aws.sdk.kotlin.services.iotroborunner.model.GetWorkerFleetRequest
import aws.sdk.kotlin.services.iotroborunner.model.GetWorkerRequest
import aws.sdk.kotlin.services.iotroborunner.model.ListDestinationsRequest
import aws.sdk.kotlin.services.iotroborunner.model.ListSitesRequest
import aws.sdk.kotlin.services.iotroborunner.model.ListWorkerFleetsRequest
import aws.sdk.kotlin.services.iotroborunner.model.ListWorkersRequest
import aws.sdk.kotlin.services.iotroborunner.model.UpdateDestinationRequest
import aws.sdk.kotlin.services.iotroborunner.model.UpdateSiteRequest
import aws.sdk.kotlin.services.iotroborunner.model.UpdateWorkerFleetRequest
import aws.sdk.kotlin.services.iotroborunner.model.UpdateWorkerRequest
import aws.sdk.kotlin.services.iotroborunner.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsHttpSigner
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.sdkRequestId
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.tracing.withRootTraceSpan
import aws.smithy.kotlin.runtime.util.putIfAbsent
import kotlin.coroutines.coroutineContext


public const val ServiceId: String = "IoT RoboRunner"
public const val ServiceApiVersion: String = "2018-05-10"
public const val SdkVersion: String = "0.21.4-beta"

internal class DefaultIotRoboRunnerClient(override val config: IotRoboRunnerClient.Config) : IotRoboRunnerClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClientEngine)

    init {
        managedResources.addIfManaged(config.httpClientEngine)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Grants permission to create a destination
     */
    override suspend fun createDestination(input: CreateDestinationRequest): CreateDestinationResponse {
        val op = SdkHttpOperation.build<CreateDestinationRequest, CreateDestinationResponse> {
            serializer = CreateDestinationOperationSerializer()
            deserializer = CreateDestinationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateDestination"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateDestinationRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "iotroborunner"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateDestination-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Grants permission to create a site
     */
    override suspend fun createSite(input: CreateSiteRequest): CreateSiteResponse {
        val op = SdkHttpOperation.build<CreateSiteRequest, CreateSiteResponse> {
            serializer = CreateSiteOperationSerializer()
            deserializer = CreateSiteOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateSite"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateSiteRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "iotroborunner"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateSite-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Grants permission to create a worker
     */
    override suspend fun createWorker(input: CreateWorkerRequest): CreateWorkerResponse {
        val op = SdkHttpOperation.build<CreateWorkerRequest, CreateWorkerResponse> {
            serializer = CreateWorkerOperationSerializer()
            deserializer = CreateWorkerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateWorker"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateWorkerRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "iotroborunner"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateWorker-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Grants permission to create a worker fleet
     */
    override suspend fun createWorkerFleet(input: CreateWorkerFleetRequest): CreateWorkerFleetResponse {
        val op = SdkHttpOperation.build<CreateWorkerFleetRequest, CreateWorkerFleetResponse> {
            serializer = CreateWorkerFleetOperationSerializer()
            deserializer = CreateWorkerFleetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateWorkerFleet"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateWorkerFleetRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "iotroborunner"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateWorkerFleet-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Grants permission to delete a destination
     */
    override suspend fun deleteDestination(input: DeleteDestinationRequest): DeleteDestinationResponse {
        val op = SdkHttpOperation.build<DeleteDestinationRequest, DeleteDestinationResponse> {
            serializer = DeleteDestinationOperationSerializer()
            deserializer = DeleteDestinationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteDestination"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteDestinationRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "iotroborunner"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteDestination-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Grants permission to delete a site
     */
    override suspend fun deleteSite(input: DeleteSiteRequest): DeleteSiteResponse {
        val op = SdkHttpOperation.build<DeleteSiteRequest, DeleteSiteResponse> {
            serializer = DeleteSiteOperationSerializer()
            deserializer = DeleteSiteOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteSite"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteSiteRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "iotroborunner"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteSite-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Grants permission to delete a worker
     */
    override suspend fun deleteWorker(input: DeleteWorkerRequest): DeleteWorkerResponse {
        val op = SdkHttpOperation.build<DeleteWorkerRequest, DeleteWorkerResponse> {
            serializer = DeleteWorkerOperationSerializer()
            deserializer = DeleteWorkerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteWorker"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteWorkerRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "iotroborunner"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteWorker-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Grants permission to delete a worker fleet
     */
    override suspend fun deleteWorkerFleet(input: DeleteWorkerFleetRequest): DeleteWorkerFleetResponse {
        val op = SdkHttpOperation.build<DeleteWorkerFleetRequest, DeleteWorkerFleetResponse> {
            serializer = DeleteWorkerFleetOperationSerializer()
            deserializer = DeleteWorkerFleetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteWorkerFleet"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteWorkerFleetRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "iotroborunner"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteWorkerFleet-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Grants permission to get a destination
     */
    override suspend fun getDestination(input: GetDestinationRequest): GetDestinationResponse {
        val op = SdkHttpOperation.build<GetDestinationRequest, GetDestinationResponse> {
            serializer = GetDestinationOperationSerializer()
            deserializer = GetDestinationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetDestination"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetDestinationRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "iotroborunner"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetDestination-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Grants permission to get a site
     */
    override suspend fun getSite(input: GetSiteRequest): GetSiteResponse {
        val op = SdkHttpOperation.build<GetSiteRequest, GetSiteResponse> {
            serializer = GetSiteOperationSerializer()
            deserializer = GetSiteOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetSite"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetSiteRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "iotroborunner"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetSite-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Grants permission to get a worker
     */
    override suspend fun getWorker(input: GetWorkerRequest): GetWorkerResponse {
        val op = SdkHttpOperation.build<GetWorkerRequest, GetWorkerResponse> {
            serializer = GetWorkerOperationSerializer()
            deserializer = GetWorkerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetWorker"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetWorkerRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "iotroborunner"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetWorker-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Grants permission to get a worker fleet
     */
    override suspend fun getWorkerFleet(input: GetWorkerFleetRequest): GetWorkerFleetResponse {
        val op = SdkHttpOperation.build<GetWorkerFleetRequest, GetWorkerFleetResponse> {
            serializer = GetWorkerFleetOperationSerializer()
            deserializer = GetWorkerFleetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetWorkerFleet"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetWorkerFleetRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "iotroborunner"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetWorkerFleet-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Grants permission to list destinations
     */
    override suspend fun listDestinations(input: ListDestinationsRequest): ListDestinationsResponse {
        val op = SdkHttpOperation.build<ListDestinationsRequest, ListDestinationsResponse> {
            serializer = ListDestinationsOperationSerializer()
            deserializer = ListDestinationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListDestinations"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListDestinationsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "iotroborunner"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListDestinations-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Grants permission to list sites
     */
    override suspend fun listSites(input: ListSitesRequest): ListSitesResponse {
        val op = SdkHttpOperation.build<ListSitesRequest, ListSitesResponse> {
            serializer = ListSitesOperationSerializer()
            deserializer = ListSitesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListSites"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListSitesRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "iotroborunner"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListSites-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Grants permission to list worker fleets
     */
    override suspend fun listWorkerFleets(input: ListWorkerFleetsRequest): ListWorkerFleetsResponse {
        val op = SdkHttpOperation.build<ListWorkerFleetsRequest, ListWorkerFleetsResponse> {
            serializer = ListWorkerFleetsOperationSerializer()
            deserializer = ListWorkerFleetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListWorkerFleets"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListWorkerFleetsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "iotroborunner"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListWorkerFleets-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Grants permission to list workers
     */
    override suspend fun listWorkers(input: ListWorkersRequest): ListWorkersResponse {
        val op = SdkHttpOperation.build<ListWorkersRequest, ListWorkersResponse> {
            serializer = ListWorkersOperationSerializer()
            deserializer = ListWorkersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListWorkers"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListWorkersRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "iotroborunner"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListWorkers-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Grants permission to update a destination
     */
    override suspend fun updateDestination(input: UpdateDestinationRequest): UpdateDestinationResponse {
        val op = SdkHttpOperation.build<UpdateDestinationRequest, UpdateDestinationResponse> {
            serializer = UpdateDestinationOperationSerializer()
            deserializer = UpdateDestinationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateDestination"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateDestinationRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "iotroborunner"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateDestination-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Grants permission to update a site
     */
    override suspend fun updateSite(input: UpdateSiteRequest): UpdateSiteResponse {
        val op = SdkHttpOperation.build<UpdateSiteRequest, UpdateSiteResponse> {
            serializer = UpdateSiteOperationSerializer()
            deserializer = UpdateSiteOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateSite"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateSiteRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "iotroborunner"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateSite-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Grants permission to update a worker
     */
    override suspend fun updateWorker(input: UpdateWorkerRequest): UpdateWorkerResponse {
        val op = SdkHttpOperation.build<UpdateWorkerRequest, UpdateWorkerResponse> {
            serializer = UpdateWorkerOperationSerializer()
            deserializer = UpdateWorkerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateWorker"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateWorkerRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "iotroborunner"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateWorker-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Grants permission to update a worker fleet
     */
    override suspend fun updateWorkerFleet(input: UpdateWorkerFleetRequest): UpdateWorkerFleetResponse {
        val op = SdkHttpOperation.build<UpdateWorkerFleetRequest, UpdateWorkerFleetResponse> {
            serializer = UpdateWorkerFleetOperationSerializer()
            deserializer = UpdateWorkerFleetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateWorkerFleet"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateWorkerFleetRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "iotroborunner"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateWorkerFleet-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "iotroborunner")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
