// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotroborunner.serde

import aws.sdk.kotlin.services.iotroborunner.model.IotRoboRunnerException
import aws.sdk.kotlin.services.iotroborunner.model.Orientation
import aws.sdk.kotlin.services.iotroborunner.model.PositionCoordinates
import aws.sdk.kotlin.services.iotroborunner.model.UpdateWorkerResponse
import aws.sdk.kotlin.services.iotroborunner.model.VendorProperties
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class UpdateWorkerOperationDeserializer: HttpDeserialize<UpdateWorkerResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): UpdateWorkerResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateWorkerError(context, call)
        }
        val builder = UpdateWorkerResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateWorkerOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwUpdateWorkerError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw IotRoboRunnerException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        else -> IotRoboRunnerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateWorkerOperationBody(builder: UpdateWorkerResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ADDITIONALFIXEDPROPERTIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("additionalFixedProperties"))
    val ADDITIONALTRANSIENTPROPERTIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("additionalTransientProperties"))
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("arn"))
    val FLEET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("fleet"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val ORIENTATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("orientation"))
    val POSITION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("position"))
    val UPDATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("updatedAt"))
    val VENDORPROPERTIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("vendorProperties"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ADDITIONALFIXEDPROPERTIES_DESCRIPTOR)
        field(ADDITIONALTRANSIENTPROPERTIES_DESCRIPTOR)
        field(ARN_DESCRIPTOR)
        field(FLEET_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(ORIENTATION_DESCRIPTOR)
        field(POSITION_DESCRIPTOR)
        field(UPDATEDAT_DESCRIPTOR)
        field(VENDORPROPERTIES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ADDITIONALFIXEDPROPERTIES_DESCRIPTOR.index -> builder.additionalFixedProperties = deserializeString()
                ADDITIONALTRANSIENTPROPERTIES_DESCRIPTOR.index -> builder.additionalTransientProperties = deserializeString()
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                FLEET_DESCRIPTOR.index -> builder.fleet = deserializeString()
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                ORIENTATION_DESCRIPTOR.index -> builder.orientation = deserializeOrientationDocument(deserializer)
                POSITION_DESCRIPTOR.index -> builder.position = deserializePositionCoordinatesDocument(deserializer)
                UPDATEDAT_DESCRIPTOR.index -> builder.updatedAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                VENDORPROPERTIES_DESCRIPTOR.index -> builder.vendorProperties = deserializeVendorPropertiesDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
