// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotroborunner.paginators

import aws.sdk.kotlin.services.iotroborunner.IotRoboRunnerClient
import aws.sdk.kotlin.services.iotroborunner.model.ListWorkersRequest
import aws.sdk.kotlin.services.iotroborunner.model.ListWorkersResponse
import aws.sdk.kotlin.services.iotroborunner.model.Worker
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListWorkersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListWorkersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorkersResponse]
 */
public fun IotRoboRunnerClient.listWorkersPaginated(initialRequest: ListWorkersRequest): Flow<ListWorkersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listWorkersPaginated.listWorkers(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListWorkersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorkersResponse]
 */
public fun IotRoboRunnerClient.listWorkersPaginated(block: ListWorkersRequest.Builder.() -> Unit): Flow<ListWorkersResponse> =
    listWorkersPaginated(ListWorkersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listWorkersPaginated]
 * to access the nested member [Worker]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Worker]
 */
@JvmName("listWorkersResponseWorker")
public fun Flow<ListWorkersResponse>.workers(): Flow<Worker> =
    transform() { response ->
        response.workers?.forEach {
            emit(it)
        }
    }
