// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotroborunner

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.iotroborunner.auth.DefaultIotRoboRunnerAuthSchemeProvider
import aws.sdk.kotlin.services.iotroborunner.auth.IotRoboRunnerAuthSchemeProvider
import aws.sdk.kotlin.services.iotroborunner.endpoints.DefaultIotRoboRunnerEndpointProvider
import aws.sdk.kotlin.services.iotroborunner.endpoints.IotRoboRunnerEndpointParameters
import aws.sdk.kotlin.services.iotroborunner.endpoints.IotRoboRunnerEndpointProvider
import aws.sdk.kotlin.services.iotroborunner.model.CreateDestinationRequest
import aws.sdk.kotlin.services.iotroborunner.model.CreateDestinationResponse
import aws.sdk.kotlin.services.iotroborunner.model.CreateSiteRequest
import aws.sdk.kotlin.services.iotroborunner.model.CreateSiteResponse
import aws.sdk.kotlin.services.iotroborunner.model.CreateWorkerFleetRequest
import aws.sdk.kotlin.services.iotroborunner.model.CreateWorkerFleetResponse
import aws.sdk.kotlin.services.iotroborunner.model.CreateWorkerRequest
import aws.sdk.kotlin.services.iotroborunner.model.CreateWorkerResponse
import aws.sdk.kotlin.services.iotroborunner.model.DeleteDestinationRequest
import aws.sdk.kotlin.services.iotroborunner.model.DeleteDestinationResponse
import aws.sdk.kotlin.services.iotroborunner.model.DeleteSiteRequest
import aws.sdk.kotlin.services.iotroborunner.model.DeleteSiteResponse
import aws.sdk.kotlin.services.iotroborunner.model.DeleteWorkerFleetRequest
import aws.sdk.kotlin.services.iotroborunner.model.DeleteWorkerFleetResponse
import aws.sdk.kotlin.services.iotroborunner.model.DeleteWorkerRequest
import aws.sdk.kotlin.services.iotroborunner.model.DeleteWorkerResponse
import aws.sdk.kotlin.services.iotroborunner.model.GetDestinationRequest
import aws.sdk.kotlin.services.iotroborunner.model.GetDestinationResponse
import aws.sdk.kotlin.services.iotroborunner.model.GetSiteRequest
import aws.sdk.kotlin.services.iotroborunner.model.GetSiteResponse
import aws.sdk.kotlin.services.iotroborunner.model.GetWorkerFleetRequest
import aws.sdk.kotlin.services.iotroborunner.model.GetWorkerFleetResponse
import aws.sdk.kotlin.services.iotroborunner.model.GetWorkerRequest
import aws.sdk.kotlin.services.iotroborunner.model.GetWorkerResponse
import aws.sdk.kotlin.services.iotroborunner.model.ListDestinationsRequest
import aws.sdk.kotlin.services.iotroborunner.model.ListDestinationsResponse
import aws.sdk.kotlin.services.iotroborunner.model.ListSitesRequest
import aws.sdk.kotlin.services.iotroborunner.model.ListSitesResponse
import aws.sdk.kotlin.services.iotroborunner.model.ListWorkerFleetsRequest
import aws.sdk.kotlin.services.iotroborunner.model.ListWorkerFleetsResponse
import aws.sdk.kotlin.services.iotroborunner.model.ListWorkersRequest
import aws.sdk.kotlin.services.iotroborunner.model.ListWorkersResponse
import aws.sdk.kotlin.services.iotroborunner.model.UpdateDestinationRequest
import aws.sdk.kotlin.services.iotroborunner.model.UpdateDestinationResponse
import aws.sdk.kotlin.services.iotroborunner.model.UpdateSiteRequest
import aws.sdk.kotlin.services.iotroborunner.model.UpdateSiteResponse
import aws.sdk.kotlin.services.iotroborunner.model.UpdateWorkerFleetRequest
import aws.sdk.kotlin.services.iotroborunner.model.UpdateWorkerFleetResponse
import aws.sdk.kotlin.services.iotroborunner.model.UpdateWorkerRequest
import aws.sdk.kotlin.services.iotroborunner.model.UpdateWorkerResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "IoT RoboRunner"
public const val SdkVersion: String = "1.0.75"
public const val ServiceApiVersion: String = "2018-05-10"

/**
 * An example service, deployed with the Octane Service creator, which will echo the string
 */
public interface IotRoboRunnerClient : SdkClient {
    /**
     * IotRoboRunnerClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, IotRoboRunnerClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "IotRoboRunner",
                "IOT_ROBORUNNER",
                "iot_roborunner",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, IotRoboRunnerClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): IotRoboRunnerClient = DefaultIotRoboRunnerClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: IotRoboRunnerEndpointProvider = builder.endpointProvider ?: DefaultIotRoboRunnerEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: IotRoboRunnerAuthSchemeProvider = builder.authSchemeProvider ?: DefaultIotRoboRunnerAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "IoT RoboRunner"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: IotRoboRunnerEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: IotRoboRunnerAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Grants permission to create a destination
     */
    public suspend fun createDestination(input: CreateDestinationRequest): CreateDestinationResponse

    /**
     * Grants permission to create a site
     */
    public suspend fun createSite(input: CreateSiteRequest): CreateSiteResponse

    /**
     * Grants permission to create a worker
     */
    public suspend fun createWorker(input: CreateWorkerRequest): CreateWorkerResponse

    /**
     * Grants permission to create a worker fleet
     */
    public suspend fun createWorkerFleet(input: CreateWorkerFleetRequest): CreateWorkerFleetResponse

    /**
     * Grants permission to delete a destination
     */
    public suspend fun deleteDestination(input: DeleteDestinationRequest): DeleteDestinationResponse

    /**
     * Grants permission to delete a site
     */
    public suspend fun deleteSite(input: DeleteSiteRequest): DeleteSiteResponse

    /**
     * Grants permission to delete a worker
     */
    public suspend fun deleteWorker(input: DeleteWorkerRequest): DeleteWorkerResponse

    /**
     * Grants permission to delete a worker fleet
     */
    public suspend fun deleteWorkerFleet(input: DeleteWorkerFleetRequest): DeleteWorkerFleetResponse

    /**
     * Grants permission to get a destination
     */
    public suspend fun getDestination(input: GetDestinationRequest): GetDestinationResponse

    /**
     * Grants permission to get a site
     */
    public suspend fun getSite(input: GetSiteRequest): GetSiteResponse

    /**
     * Grants permission to get a worker
     */
    public suspend fun getWorker(input: GetWorkerRequest): GetWorkerResponse

    /**
     * Grants permission to get a worker fleet
     */
    public suspend fun getWorkerFleet(input: GetWorkerFleetRequest): GetWorkerFleetResponse

    /**
     * Grants permission to list destinations
     */
    public suspend fun listDestinations(input: ListDestinationsRequest): ListDestinationsResponse

    /**
     * Grants permission to list sites
     */
    public suspend fun listSites(input: ListSitesRequest = ListSitesRequest { }): ListSitesResponse

    /**
     * Grants permission to list worker fleets
     */
    public suspend fun listWorkerFleets(input: ListWorkerFleetsRequest): ListWorkerFleetsResponse

    /**
     * Grants permission to list workers
     */
    public suspend fun listWorkers(input: ListWorkersRequest): ListWorkersResponse

    /**
     * Grants permission to update a destination
     */
    public suspend fun updateDestination(input: UpdateDestinationRequest): UpdateDestinationResponse

    /**
     * Grants permission to update a site
     */
    public suspend fun updateSite(input: UpdateSiteRequest): UpdateSiteResponse

    /**
     * Grants permission to update a worker
     */
    public suspend fun updateWorker(input: UpdateWorkerRequest): UpdateWorkerResponse

    /**
     * Grants permission to update a worker fleet
     */
    public suspend fun updateWorkerFleet(input: UpdateWorkerFleetRequest): UpdateWorkerFleetResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun IotRoboRunnerClient.withConfig(block: IotRoboRunnerClient.Config.Builder.() -> Unit): IotRoboRunnerClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultIotRoboRunnerClient(newConfig)
}

/**
 * Grants permission to create a destination
 */
public suspend inline fun IotRoboRunnerClient.createDestination(crossinline block: CreateDestinationRequest.Builder.() -> Unit): CreateDestinationResponse = createDestination(CreateDestinationRequest.Builder().apply(block).build())

/**
 * Grants permission to create a site
 */
public suspend inline fun IotRoboRunnerClient.createSite(crossinline block: CreateSiteRequest.Builder.() -> Unit): CreateSiteResponse = createSite(CreateSiteRequest.Builder().apply(block).build())

/**
 * Grants permission to create a worker
 */
public suspend inline fun IotRoboRunnerClient.createWorker(crossinline block: CreateWorkerRequest.Builder.() -> Unit): CreateWorkerResponse = createWorker(CreateWorkerRequest.Builder().apply(block).build())

/**
 * Grants permission to create a worker fleet
 */
public suspend inline fun IotRoboRunnerClient.createWorkerFleet(crossinline block: CreateWorkerFleetRequest.Builder.() -> Unit): CreateWorkerFleetResponse = createWorkerFleet(CreateWorkerFleetRequest.Builder().apply(block).build())

/**
 * Grants permission to delete a destination
 */
public suspend inline fun IotRoboRunnerClient.deleteDestination(crossinline block: DeleteDestinationRequest.Builder.() -> Unit): DeleteDestinationResponse = deleteDestination(DeleteDestinationRequest.Builder().apply(block).build())

/**
 * Grants permission to delete a site
 */
public suspend inline fun IotRoboRunnerClient.deleteSite(crossinline block: DeleteSiteRequest.Builder.() -> Unit): DeleteSiteResponse = deleteSite(DeleteSiteRequest.Builder().apply(block).build())

/**
 * Grants permission to delete a worker
 */
public suspend inline fun IotRoboRunnerClient.deleteWorker(crossinline block: DeleteWorkerRequest.Builder.() -> Unit): DeleteWorkerResponse = deleteWorker(DeleteWorkerRequest.Builder().apply(block).build())

/**
 * Grants permission to delete a worker fleet
 */
public suspend inline fun IotRoboRunnerClient.deleteWorkerFleet(crossinline block: DeleteWorkerFleetRequest.Builder.() -> Unit): DeleteWorkerFleetResponse = deleteWorkerFleet(DeleteWorkerFleetRequest.Builder().apply(block).build())

/**
 * Grants permission to get a destination
 */
public suspend inline fun IotRoboRunnerClient.getDestination(crossinline block: GetDestinationRequest.Builder.() -> Unit): GetDestinationResponse = getDestination(GetDestinationRequest.Builder().apply(block).build())

/**
 * Grants permission to get a site
 */
public suspend inline fun IotRoboRunnerClient.getSite(crossinline block: GetSiteRequest.Builder.() -> Unit): GetSiteResponse = getSite(GetSiteRequest.Builder().apply(block).build())

/**
 * Grants permission to get a worker
 */
public suspend inline fun IotRoboRunnerClient.getWorker(crossinline block: GetWorkerRequest.Builder.() -> Unit): GetWorkerResponse = getWorker(GetWorkerRequest.Builder().apply(block).build())

/**
 * Grants permission to get a worker fleet
 */
public suspend inline fun IotRoboRunnerClient.getWorkerFleet(crossinline block: GetWorkerFleetRequest.Builder.() -> Unit): GetWorkerFleetResponse = getWorkerFleet(GetWorkerFleetRequest.Builder().apply(block).build())

/**
 * Grants permission to list destinations
 */
public suspend inline fun IotRoboRunnerClient.listDestinations(crossinline block: ListDestinationsRequest.Builder.() -> Unit): ListDestinationsResponse = listDestinations(ListDestinationsRequest.Builder().apply(block).build())

/**
 * Grants permission to list sites
 */
public suspend inline fun IotRoboRunnerClient.listSites(crossinline block: ListSitesRequest.Builder.() -> Unit): ListSitesResponse = listSites(ListSitesRequest.Builder().apply(block).build())

/**
 * Grants permission to list worker fleets
 */
public suspend inline fun IotRoboRunnerClient.listWorkerFleets(crossinline block: ListWorkerFleetsRequest.Builder.() -> Unit): ListWorkerFleetsResponse = listWorkerFleets(ListWorkerFleetsRequest.Builder().apply(block).build())

/**
 * Grants permission to list workers
 */
public suspend inline fun IotRoboRunnerClient.listWorkers(crossinline block: ListWorkersRequest.Builder.() -> Unit): ListWorkersResponse = listWorkers(ListWorkersRequest.Builder().apply(block).build())

/**
 * Grants permission to update a destination
 */
public suspend inline fun IotRoboRunnerClient.updateDestination(crossinline block: UpdateDestinationRequest.Builder.() -> Unit): UpdateDestinationResponse = updateDestination(UpdateDestinationRequest.Builder().apply(block).build())

/**
 * Grants permission to update a site
 */
public suspend inline fun IotRoboRunnerClient.updateSite(crossinline block: UpdateSiteRequest.Builder.() -> Unit): UpdateSiteResponse = updateSite(UpdateSiteRequest.Builder().apply(block).build())

/**
 * Grants permission to update a worker
 */
public suspend inline fun IotRoboRunnerClient.updateWorker(crossinline block: UpdateWorkerRequest.Builder.() -> Unit): UpdateWorkerResponse = updateWorker(UpdateWorkerRequest.Builder().apply(block).build())

/**
 * Grants permission to update a worker fleet
 */
public suspend inline fun IotRoboRunnerClient.updateWorkerFleet(crossinline block: UpdateWorkerFleetRequest.Builder.() -> Unit): UpdateWorkerFleetResponse = updateWorkerFleet(UpdateWorkerFleetRequest.Builder().apply(block).build())
