// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotfleetwise.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iotfleetwise.model.IamResources
import aws.sdk.kotlin.services.iotfleetwise.model.IoTFleetWiseException
import aws.sdk.kotlin.services.iotfleetwise.model.RegisterAccountResponse
import aws.sdk.kotlin.services.iotfleetwise.model.RegistrationStatus
import aws.sdk.kotlin.services.iotfleetwise.model.TimestreamResources
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class RegisterAccountOperationDeserializer: HttpDeserialize<RegisterAccountResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): RegisterAccountResponse {
        if (!response.status.isSuccess()) {
            throwRegisterAccountError(context, response)
        }
        val builder = RegisterAccountResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeRegisterAccountOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwRegisterAccountError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IoTFleetWiseException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IoTFleetWiseException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeRegisterAccountOperationBody(builder: RegisterAccountResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationTime"))
    val IAMRESOURCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("iamResources"))
    val LASTMODIFICATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastModificationTime"))
    val REGISTERACCOUNTSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("registerAccountStatus"))
    val TIMESTREAMRESOURCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("timestreamResources"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONTIME_DESCRIPTOR)
        field(IAMRESOURCES_DESCRIPTOR)
        field(LASTMODIFICATIONTIME_DESCRIPTOR)
        field(REGISTERACCOUNTSTATUS_DESCRIPTOR)
        field(TIMESTREAMRESOURCES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                IAMRESOURCES_DESCRIPTOR.index -> builder.iamResources = deserializeIamResourcesDocument(deserializer)
                LASTMODIFICATIONTIME_DESCRIPTOR.index -> builder.lastModificationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                REGISTERACCOUNTSTATUS_DESCRIPTOR.index -> builder.registerAccountStatus = deserializeString().let { RegistrationStatus.fromValue(it) }
                TIMESTREAMRESOURCES_DESCRIPTOR.index -> builder.timestreamResources = deserializeTimestreamResourcesDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
