// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotfleetwise.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iotfleetwise.model.GetVehicleResponse
import aws.sdk.kotlin.services.iotfleetwise.model.IoTFleetWiseException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetVehicleOperationDeserializer: HttpDeserialize<GetVehicleResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetVehicleResponse {
        if (!response.status.isSuccess()) {
            throwGetVehicleError(context, response)
        }
        val builder = GetVehicleResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetVehicleOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetVehicleError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IoTFleetWiseException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IoTFleetWiseException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetVehicleOperationBody(builder: GetVehicleResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("arn"))
    val ATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("attributes"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationTime"))
    val DECODERMANIFESTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("decoderManifestArn"))
    val LASTMODIFICATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastModificationTime"))
    val MODELMANIFESTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("modelManifestArn"))
    val VEHICLENAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("vehicleName"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(ATTRIBUTES_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(DECODERMANIFESTARN_DESCRIPTOR)
        field(LASTMODIFICATIONTIME_DESCRIPTOR)
        field(MODELMANIFESTARN_DESCRIPTOR)
        field(VEHICLENAME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                ATTRIBUTES_DESCRIPTOR.index -> builder.attributes =
                    deserializer.deserializeMap(ATTRIBUTES_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DECODERMANIFESTARN_DESCRIPTOR.index -> builder.decoderManifestArn = deserializeString()
                LASTMODIFICATIONTIME_DESCRIPTOR.index -> builder.lastModificationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                MODELMANIFESTARN_DESCRIPTOR.index -> builder.modelManifestArn = deserializeString()
                VEHICLENAME_DESCRIPTOR.index -> builder.vehicleName = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
