// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotfleetwise.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iotfleetwise.model.GetRegisterAccountStatusResponse
import aws.sdk.kotlin.services.iotfleetwise.model.IamRegistrationResponse
import aws.sdk.kotlin.services.iotfleetwise.model.IoTFleetWiseException
import aws.sdk.kotlin.services.iotfleetwise.model.RegistrationStatus
import aws.sdk.kotlin.services.iotfleetwise.model.TimestreamRegistrationResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetRegisterAccountStatusOperationDeserializer: HttpDeserialize<GetRegisterAccountStatusResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetRegisterAccountStatusResponse {
        if (!response.status.isSuccess()) {
            throwGetRegisterAccountStatusError(context, response)
        }
        val builder = GetRegisterAccountStatusResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetRegisterAccountStatusOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetRegisterAccountStatusError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IoTFleetWiseException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IoTFleetWiseException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetRegisterAccountStatusOperationBody(builder: GetRegisterAccountStatusResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACCOUNTSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("accountStatus"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationTime"))
    val CUSTOMERACCOUNTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("customerAccountId"))
    val IAMREGISTRATIONRESPONSE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("iamRegistrationResponse"))
    val LASTMODIFICATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastModificationTime"))
    val TIMESTREAMREGISTRATIONRESPONSE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("timestreamRegistrationResponse"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCOUNTSTATUS_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(CUSTOMERACCOUNTID_DESCRIPTOR)
        field(IAMREGISTRATIONRESPONSE_DESCRIPTOR)
        field(LASTMODIFICATIONTIME_DESCRIPTOR)
        field(TIMESTREAMREGISTRATIONRESPONSE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACCOUNTSTATUS_DESCRIPTOR.index -> builder.accountStatus = deserializeString().let { RegistrationStatus.fromValue(it) }
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                CUSTOMERACCOUNTID_DESCRIPTOR.index -> builder.customerAccountId = deserializeString()
                IAMREGISTRATIONRESPONSE_DESCRIPTOR.index -> builder.iamRegistrationResponse = deserializeIamRegistrationResponseDocument(deserializer)
                LASTMODIFICATIONTIME_DESCRIPTOR.index -> builder.lastModificationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                TIMESTREAMREGISTRATIONRESPONSE_DESCRIPTOR.index -> builder.timestreamRegistrationResponse = deserializeTimestreamRegistrationResponseDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
