// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotfleetwise.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iotfleetwise.model.CampaignStatus
import aws.sdk.kotlin.services.iotfleetwise.model.CollectionScheme
import aws.sdk.kotlin.services.iotfleetwise.model.Compression
import aws.sdk.kotlin.services.iotfleetwise.model.DiagnosticsMode
import aws.sdk.kotlin.services.iotfleetwise.model.GetCampaignResponse
import aws.sdk.kotlin.services.iotfleetwise.model.IoTFleetWiseException
import aws.sdk.kotlin.services.iotfleetwise.model.SignalInformation
import aws.sdk.kotlin.services.iotfleetwise.model.SpoolingMode
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetCampaignOperationDeserializer: HttpDeserialize<GetCampaignResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetCampaignResponse {
        if (!response.status.isSuccess()) {
            throwGetCampaignError(context, response)
        }
        val builder = GetCampaignResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetCampaignOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetCampaignError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IoTFleetWiseException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IoTFleetWiseException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetCampaignOperationBody(builder: GetCampaignResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("arn"))
    val COLLECTIONSCHEME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("collectionScheme"))
    val COMPRESSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("compression"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationTime"))
    val DATAEXTRADIMENSIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("dataExtraDimensions"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val DIAGNOSTICSMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("diagnosticsMode"))
    val EXPIRYTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("expiryTime"))
    val LASTMODIFICATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastModificationTime"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val POSTTRIGGERCOLLECTIONDURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("postTriggerCollectionDuration"))
    val PRIORITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("priority"))
    val SIGNALCATALOGARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("signalCatalogArn"))
    val SIGNALSTOCOLLECT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("signalsToCollect"))
    val SPOOLINGMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("spoolingMode"))
    val STARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("startTime"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("status"))
    val TARGETARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("targetArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(COLLECTIONSCHEME_DESCRIPTOR)
        field(COMPRESSION_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(DATAEXTRADIMENSIONS_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(DIAGNOSTICSMODE_DESCRIPTOR)
        field(EXPIRYTIME_DESCRIPTOR)
        field(LASTMODIFICATIONTIME_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(POSTTRIGGERCOLLECTIONDURATION_DESCRIPTOR)
        field(PRIORITY_DESCRIPTOR)
        field(SIGNALCATALOGARN_DESCRIPTOR)
        field(SIGNALSTOCOLLECT_DESCRIPTOR)
        field(SPOOLINGMODE_DESCRIPTOR)
        field(STARTTIME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TARGETARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                COLLECTIONSCHEME_DESCRIPTOR.index -> builder.collectionScheme = deserializeCollectionSchemeDocument(deserializer)
                COMPRESSION_DESCRIPTOR.index -> builder.compression = deserializeString().let { Compression.fromValue(it) }
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DATAEXTRADIMENSIONS_DESCRIPTOR.index -> builder.dataExtraDimensions =
                    deserializer.deserializeList(DATAEXTRADIMENSIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                DIAGNOSTICSMODE_DESCRIPTOR.index -> builder.diagnosticsMode = deserializeString().let { DiagnosticsMode.fromValue(it) }
                EXPIRYTIME_DESCRIPTOR.index -> builder.expiryTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                LASTMODIFICATIONTIME_DESCRIPTOR.index -> builder.lastModificationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                POSTTRIGGERCOLLECTIONDURATION_DESCRIPTOR.index -> builder.postTriggerCollectionDuration = deserializeLong()
                PRIORITY_DESCRIPTOR.index -> builder.priority = deserializeInt()
                SIGNALCATALOGARN_DESCRIPTOR.index -> builder.signalCatalogArn = deserializeString()
                SIGNALSTOCOLLECT_DESCRIPTOR.index -> builder.signalsToCollect =
                    deserializer.deserializeList(SIGNALSTOCOLLECT_DESCRIPTOR) {
                        val col0 = mutableListOf<SignalInformation>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSignalInformationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SPOOLINGMODE_DESCRIPTOR.index -> builder.spoolingMode = deserializeString().let { SpoolingMode.fromValue(it) }
                STARTTIME_DESCRIPTOR.index -> builder.startTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { CampaignStatus.fromValue(it) }
                TARGETARN_DESCRIPTOR.index -> builder.targetArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
