// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotfleetwise.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iotfleetwise.model.BatchCreateVehicleResponse
import aws.sdk.kotlin.services.iotfleetwise.model.CreateVehicleError
import aws.sdk.kotlin.services.iotfleetwise.model.CreateVehicleResponseItem
import aws.sdk.kotlin.services.iotfleetwise.model.IoTFleetWiseException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class BatchCreateVehicleOperationDeserializer: HttpDeserialize<BatchCreateVehicleResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): BatchCreateVehicleResponse {
        if (!response.status.isSuccess()) {
            throwBatchCreateVehicleError(context, response)
        }
        val builder = BatchCreateVehicleResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeBatchCreateVehicleOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwBatchCreateVehicleError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IoTFleetWiseException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IoTFleetWiseException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchCreateVehicleOperationBody(builder: BatchCreateVehicleResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ERRORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("errors"))
    val VEHICLES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("vehicles"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ERRORS_DESCRIPTOR)
        field(VEHICLES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ERRORS_DESCRIPTOR.index -> builder.errors =
                    deserializer.deserializeList(ERRORS_DESCRIPTOR) {
                        val col0 = mutableListOf<CreateVehicleError>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeCreateVehicleErrorDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                VEHICLES_DESCRIPTOR.index -> builder.vehicles =
                    deserializer.deserializeList(VEHICLES_DESCRIPTOR) {
                        val col0 = mutableListOf<CreateVehicleResponseItem>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeCreateVehicleResponseItemDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
