// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotfleetwise.paginators

import aws.sdk.kotlin.services.iotfleetwise.IoTFleetWiseClient
import aws.sdk.kotlin.services.iotfleetwise.model.GetVehicleStatusRequest
import aws.sdk.kotlin.services.iotfleetwise.model.GetVehicleStatusResponse
import aws.sdk.kotlin.services.iotfleetwise.model.VehicleStatus
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [GetVehicleStatusResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [GetVehicleStatusRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetVehicleStatusResponse]
 */
public fun IoTFleetWiseClient.getVehicleStatusPaginated(initialRequest: GetVehicleStatusRequest): Flow<GetVehicleStatusResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@getVehicleStatusPaginated.getVehicleStatus(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [GetVehicleStatusResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GetVehicleStatusResponse]
 */
public fun IoTFleetWiseClient.getVehicleStatusPaginated(block: GetVehicleStatusRequest.Builder.() -> Unit): Flow<GetVehicleStatusResponse> =
    getVehicleStatusPaginated(GetVehicleStatusRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [getVehicleStatusPaginated]
 * to access the nested member [VehicleStatus]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [VehicleStatus]
 */
@JvmName("getVehicleStatusResponseVehicleStatus")
public fun Flow<GetVehicleStatusResponse>.campaigns(): Flow<VehicleStatus> =
    transform() { response ->
        response.campaigns?.forEach {
            emit(it)
        }
    }
