// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotfleetwise.model



/**
 * Information about the state of a vehicle and how it relates to the status of a campaign.
 */
public class VehicleStatus private constructor(builder: Builder) {
    /**
     * The name of a campaign.
     */
    public val campaignName: kotlin.String? = builder.campaignName
    /**
     * The state of a vehicle, which can be one of the following:
     * + `CREATED` - Amazon Web Services IoT FleetWise sucessfully created the vehicle.
     * + `READY` - The vehicle is ready to receive a campaign deployment.
     * + `HEALTHY` - A campaign deployment was delivered to the vehicle.
     * + `SUSPENDED` - A campaign associated with the vehicle was suspended and data collection was paused.
     * + `DELETING` - Amazon Web Services IoT FleetWise is removing a campaign from the vehicle.
     */
    public val status: aws.sdk.kotlin.services.iotfleetwise.model.VehicleState? = builder.status
    /**
     * The unique ID of the vehicle.
     */
    public val vehicleName: kotlin.String? = builder.vehicleName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotfleetwise.model.VehicleStatus = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VehicleStatus(")
        append("campaignName=$campaignName,")
        append("status=$status,")
        append("vehicleName=$vehicleName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = campaignName?.hashCode() ?: 0
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (vehicleName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VehicleStatus

        if (campaignName != other.campaignName) return false
        if (status != other.status) return false
        if (vehicleName != other.vehicleName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotfleetwise.model.VehicleStatus = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of a campaign.
         */
        public var campaignName: kotlin.String? = null
        /**
         * The state of a vehicle, which can be one of the following:
         * + `CREATED` - Amazon Web Services IoT FleetWise sucessfully created the vehicle.
         * + `READY` - The vehicle is ready to receive a campaign deployment.
         * + `HEALTHY` - A campaign deployment was delivered to the vehicle.
         * + `SUSPENDED` - A campaign associated with the vehicle was suspended and data collection was paused.
         * + `DELETING` - Amazon Web Services IoT FleetWise is removing a campaign from the vehicle.
         */
        public var status: aws.sdk.kotlin.services.iotfleetwise.model.VehicleState? = null
        /**
         * The unique ID of the vehicle.
         */
        public var vehicleName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotfleetwise.model.VehicleStatus) : this() {
            this.campaignName = x.campaignName
            this.status = x.status
            this.vehicleName = x.vehicleName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotfleetwise.model.VehicleStatus = VehicleStatus(this)
    }
}
