// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotfleetwise.model



/**
 * An input component that reports the environmental condition of a vehicle.
 *
 * You can collect data about fluid levels, temperatures, vibrations, or battery voltage from sensors.
 */
public class Sensor private constructor(builder: Builder) {
    /**
     * A list of possible values a sensor can take.
     */
    public val allowedValues: List<String>? = builder.allowedValues
    /**
     * The specified data type of the sensor.
     */
    public val dataType: aws.sdk.kotlin.services.iotfleetwise.model.NodeDataType? = builder.dataType
    /**
     * A brief description of a sensor.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The fully qualified name of the sensor. For example, the fully qualified name of a sensor might be `Vehicle.Body.Engine.Battery`.
     */
    public val fullyQualifiedName: kotlin.String? = builder.fullyQualifiedName
    /**
     * The specified possible maximum value of the sensor.
     */
    public val max: kotlin.Double? = builder.max
    /**
     * The specified possible minimum value of the sensor.
     */
    public val min: kotlin.Double? = builder.min
    /**
     * The scientific unit of measurement for data collected by the sensor.
     */
    public val unit: kotlin.String? = builder.unit

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotfleetwise.model.Sensor = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Sensor(")
        append("allowedValues=$allowedValues,")
        append("dataType=$dataType,")
        append("description=$description,")
        append("fullyQualifiedName=$fullyQualifiedName,")
        append("max=$max,")
        append("min=$min,")
        append("unit=$unit)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowedValues?.hashCode() ?: 0
        result = 31 * result + (dataType?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (fullyQualifiedName?.hashCode() ?: 0)
        result = 31 * result + (max?.hashCode() ?: 0)
        result = 31 * result + (min?.hashCode() ?: 0)
        result = 31 * result + (unit?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Sensor

        if (allowedValues != other.allowedValues) return false
        if (dataType != other.dataType) return false
        if (description != other.description) return false
        if (fullyQualifiedName != other.fullyQualifiedName) return false
        if (max != other.max) return false
        if (min != other.min) return false
        if (unit != other.unit) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotfleetwise.model.Sensor = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of possible values a sensor can take.
         */
        public var allowedValues: List<String>? = null
        /**
         * The specified data type of the sensor.
         */
        public var dataType: aws.sdk.kotlin.services.iotfleetwise.model.NodeDataType? = null
        /**
         * A brief description of a sensor.
         */
        public var description: kotlin.String? = null
        /**
         * The fully qualified name of the sensor. For example, the fully qualified name of a sensor might be `Vehicle.Body.Engine.Battery`.
         */
        public var fullyQualifiedName: kotlin.String? = null
        /**
         * The specified possible maximum value of the sensor.
         */
        public var max: kotlin.Double? = null
        /**
         * The specified possible minimum value of the sensor.
         */
        public var min: kotlin.Double? = null
        /**
         * The scientific unit of measurement for data collected by the sensor.
         */
        public var unit: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotfleetwise.model.Sensor) : this() {
            this.allowedValues = x.allowedValues
            this.dataType = x.dataType
            this.description = x.description
            this.fullyQualifiedName = x.fullyQualifiedName
            this.max = x.max
            this.min = x.min
            this.unit = x.unit
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotfleetwise.model.Sensor = Sensor(this)
    }
}
