// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotfleetwise.model



/**
 * A network interface that specifies the On-board diagnostic (OBD) II network protocol.
 */
public class ObdInterface private constructor(builder: Builder) {
    /**
     * The maximum number message requests per diagnostic trouble code per second.
     */
    public val dtcRequestIntervalSeconds: kotlin.Int = builder.dtcRequestIntervalSeconds
    /**
     * Whether the vehicle has a transmission control module (TCM).
     */
    public val hasTransmissionEcu: kotlin.Boolean = builder.hasTransmissionEcu
    /**
     * The name of the interface.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The standard OBD II PID.
     */
    public val obdStandard: kotlin.String? = builder.obdStandard
    /**
     * The maximum number message requests per second.
     */
    public val pidRequestIntervalSeconds: kotlin.Int = builder.pidRequestIntervalSeconds
    /**
     * The ID of the message requesting vehicle data.
     */
    public val requestMessageId: kotlin.Int = builder.requestMessageId
    /**
     * Whether to use extended IDs in the message.
     */
    public val useExtendedIds: kotlin.Boolean = builder.useExtendedIds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotfleetwise.model.ObdInterface = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ObdInterface(")
        append("dtcRequestIntervalSeconds=$dtcRequestIntervalSeconds,")
        append("hasTransmissionEcu=$hasTransmissionEcu,")
        append("name=$name,")
        append("obdStandard=$obdStandard,")
        append("pidRequestIntervalSeconds=$pidRequestIntervalSeconds,")
        append("requestMessageId=$requestMessageId,")
        append("useExtendedIds=$useExtendedIds)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dtcRequestIntervalSeconds
        result = 31 * result + (hasTransmissionEcu.hashCode())
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (obdStandard?.hashCode() ?: 0)
        result = 31 * result + (pidRequestIntervalSeconds)
        result = 31 * result + (requestMessageId)
        result = 31 * result + (useExtendedIds.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ObdInterface

        if (dtcRequestIntervalSeconds != other.dtcRequestIntervalSeconds) return false
        if (hasTransmissionEcu != other.hasTransmissionEcu) return false
        if (name != other.name) return false
        if (obdStandard != other.obdStandard) return false
        if (pidRequestIntervalSeconds != other.pidRequestIntervalSeconds) return false
        if (requestMessageId != other.requestMessageId) return false
        if (useExtendedIds != other.useExtendedIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotfleetwise.model.ObdInterface = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The maximum number message requests per diagnostic trouble code per second.
         */
        public var dtcRequestIntervalSeconds: kotlin.Int = 0
        /**
         * Whether the vehicle has a transmission control module (TCM).
         */
        public var hasTransmissionEcu: kotlin.Boolean = false
        /**
         * The name of the interface.
         */
        public var name: kotlin.String? = null
        /**
         * The standard OBD II PID.
         */
        public var obdStandard: kotlin.String? = null
        /**
         * The maximum number message requests per second.
         */
        public var pidRequestIntervalSeconds: kotlin.Int = 0
        /**
         * The ID of the message requesting vehicle data.
         */
        public var requestMessageId: kotlin.Int = 0
        /**
         * Whether to use extended IDs in the message.
         */
        public var useExtendedIds: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotfleetwise.model.ObdInterface) : this() {
            this.dtcRequestIntervalSeconds = x.dtcRequestIntervalSeconds
            this.hasTransmissionEcu = x.hasTransmissionEcu
            this.name = x.name
            this.obdStandard = x.obdStandard
            this.pidRequestIntervalSeconds = x.pidRequestIntervalSeconds
            this.requestMessageId = x.requestMessageId
            this.useExtendedIds = x.useExtendedIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotfleetwise.model.ObdInterface = ObdInterface(this)
    }
}
