// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotfleetwise.model



/**
 * Represents a node and its specifications in an in-vehicle communication network. All signal decoders must be associated with a network node.
 *
 *  To return this information about all the network interfaces specified in a decoder manifest, use the API operation.
 */
public class NetworkInterface private constructor(builder: Builder) {
    /**
     * Information about a network interface specified by the Controller Area Network (CAN) protocol.
     */
    public val canInterface: aws.sdk.kotlin.services.iotfleetwise.model.CanInterface? = builder.canInterface
    /**
     * The ID of the network interface.
     */
    public val interfaceId: kotlin.String? = builder.interfaceId
    /**
     * Information about a network interface specified by the On-board diagnostic (OBD) II protocol.
     */
    public val obdInterface: aws.sdk.kotlin.services.iotfleetwise.model.ObdInterface? = builder.obdInterface
    /**
     * The network protocol for the vehicle. For example, `CAN_SIGNAL` specifies a protocol that defines how data is communicated between electronic control units (ECUs). `OBD_SIGNAL` specifies a protocol that defines how self-diagnostic data is communicated between ECUs.
     */
    public val type: aws.sdk.kotlin.services.iotfleetwise.model.NetworkInterfaceType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotfleetwise.model.NetworkInterface = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NetworkInterface(")
        append("canInterface=$canInterface,")
        append("interfaceId=$interfaceId,")
        append("obdInterface=$obdInterface,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = canInterface?.hashCode() ?: 0
        result = 31 * result + (interfaceId?.hashCode() ?: 0)
        result = 31 * result + (obdInterface?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NetworkInterface

        if (canInterface != other.canInterface) return false
        if (interfaceId != other.interfaceId) return false
        if (obdInterface != other.obdInterface) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotfleetwise.model.NetworkInterface = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Information about a network interface specified by the Controller Area Network (CAN) protocol.
         */
        public var canInterface: aws.sdk.kotlin.services.iotfleetwise.model.CanInterface? = null
        /**
         * The ID of the network interface.
         */
        public var interfaceId: kotlin.String? = null
        /**
         * Information about a network interface specified by the On-board diagnostic (OBD) II protocol.
         */
        public var obdInterface: aws.sdk.kotlin.services.iotfleetwise.model.ObdInterface? = null
        /**
         * The network protocol for the vehicle. For example, `CAN_SIGNAL` specifies a protocol that defines how data is communicated between electronic control units (ECUs). `OBD_SIGNAL` specifies a protocol that defines how self-diagnostic data is communicated between ECUs.
         */
        public var type: aws.sdk.kotlin.services.iotfleetwise.model.NetworkInterfaceType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotfleetwise.model.NetworkInterface) : this() {
            this.canInterface = x.canInterface
            this.interfaceId = x.interfaceId
            this.obdInterface = x.obdInterface
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotfleetwise.model.NetworkInterface = NetworkInterface(this)

        /**
         * construct an [aws.sdk.kotlin.services.iotfleetwise.model.CanInterface] inside the given [block]
         */
        public fun canInterface(block: aws.sdk.kotlin.services.iotfleetwise.model.CanInterface.Builder.() -> kotlin.Unit) {
            this.canInterface = aws.sdk.kotlin.services.iotfleetwise.model.CanInterface.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.iotfleetwise.model.ObdInterface] inside the given [block]
         */
        public fun obdInterface(block: aws.sdk.kotlin.services.iotfleetwise.model.ObdInterface.Builder.() -> kotlin.Unit) {
            this.obdInterface = aws.sdk.kotlin.services.iotfleetwise.model.ObdInterface.invoke(block)
        }
    }
}
