// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotfleetwise.model



/**
 * Information about a collection scheme that uses a simple logical expression to recognize what data to collect.
 */
public class ConditionBasedCollectionScheme private constructor(builder: Builder) {
    /**
     * Specifies the version of the conditional expression language.
     */
    public val conditionLanguageVersion: kotlin.Int? = builder.conditionLanguageVersion
    /**
     * The logical expression used to recognize what data to collect. For example, `$variable.Vehicle.OutsideAirTemperature &gt;= 105.0`.
     */
    public val expression: kotlin.String? = builder.expression
    /**
     * The minimum duration of time between two triggering events to collect data, in milliseconds.
     *
     * If a signal changes often, you might want to collect data at a slower rate.
     */
    public val minimumTriggerIntervalMs: kotlin.Long? = builder.minimumTriggerIntervalMs
    /**
     * Whether to collect data for all triggering events (`ALWAYS`). Specify (`RISING_EDGE`), or specify only when the condition first evaluates to false. For example, triggering on "AirbagDeployed"; Users aren't interested on triggering when the airbag is already exploded; they only care about the change from not deployed => deployed.
     */
    public val triggerMode: aws.sdk.kotlin.services.iotfleetwise.model.TriggerMode? = builder.triggerMode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotfleetwise.model.ConditionBasedCollectionScheme = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ConditionBasedCollectionScheme(")
        append("conditionLanguageVersion=$conditionLanguageVersion,")
        append("expression=$expression,")
        append("minimumTriggerIntervalMs=$minimumTriggerIntervalMs,")
        append("triggerMode=$triggerMode)")
    }

    override fun hashCode(): kotlin.Int {
        var result = conditionLanguageVersion ?: 0
        result = 31 * result + (expression?.hashCode() ?: 0)
        result = 31 * result + (minimumTriggerIntervalMs?.hashCode() ?: 0)
        result = 31 * result + (triggerMode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ConditionBasedCollectionScheme

        if (conditionLanguageVersion != other.conditionLanguageVersion) return false
        if (expression != other.expression) return false
        if (minimumTriggerIntervalMs != other.minimumTriggerIntervalMs) return false
        if (triggerMode != other.triggerMode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotfleetwise.model.ConditionBasedCollectionScheme = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the version of the conditional expression language.
         */
        public var conditionLanguageVersion: kotlin.Int? = null
        /**
         * The logical expression used to recognize what data to collect. For example, `$variable.Vehicle.OutsideAirTemperature &gt;= 105.0`.
         */
        public var expression: kotlin.String? = null
        /**
         * The minimum duration of time between two triggering events to collect data, in milliseconds.
         *
         * If a signal changes often, you might want to collect data at a slower rate.
         */
        public var minimumTriggerIntervalMs: kotlin.Long? = null
        /**
         * Whether to collect data for all triggering events (`ALWAYS`). Specify (`RISING_EDGE`), or specify only when the condition first evaluates to false. For example, triggering on "AirbagDeployed"; Users aren't interested on triggering when the airbag is already exploded; they only care about the change from not deployed => deployed.
         */
        public var triggerMode: aws.sdk.kotlin.services.iotfleetwise.model.TriggerMode? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotfleetwise.model.ConditionBasedCollectionScheme) : this() {
            this.conditionLanguageVersion = x.conditionLanguageVersion
            this.expression = x.expression
            this.minimumTriggerIntervalMs = x.minimumTriggerIntervalMs
            this.triggerMode = x.triggerMode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotfleetwise.model.ConditionBasedCollectionScheme = ConditionBasedCollectionScheme(this)
    }
}
