// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotfleetwise.model



/**
 * Information about a single controller area network (CAN) signal and the messages it receives and transmits.
 */
public class CanSignal private constructor(builder: Builder) {
    /**
     * A multiplier used to decode the CAN message.
     */
    public val factor: kotlin.Double? = builder.factor
    /**
     * Whether the byte ordering of a CAN message is big-endian.
     */
    public val isBigEndian: kotlin.Boolean = builder.isBigEndian
    /**
     * Whether the message data is specified as a signed value.
     */
    public val isSigned: kotlin.Boolean = builder.isSigned
    /**
     * How many bytes of data are in the message.
     */
    public val length: kotlin.Int = builder.length
    /**
     * The ID of the message.
     */
    public val messageId: kotlin.Int = builder.messageId
    /**
     * The name of the signal.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Indicates where data appears in the CAN message.
     */
    public val offset: kotlin.Double? = builder.offset
    /**
     * Indicates the beginning of the CAN message.
     */
    public val startBit: kotlin.Int = builder.startBit

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotfleetwise.model.CanSignal = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CanSignal(")
        append("factor=$factor,")
        append("isBigEndian=$isBigEndian,")
        append("isSigned=$isSigned,")
        append("length=$length,")
        append("messageId=$messageId,")
        append("name=$name,")
        append("offset=$offset,")
        append("startBit=$startBit)")
    }

    override fun hashCode(): kotlin.Int {
        var result = factor?.hashCode() ?: 0
        result = 31 * result + (isBigEndian.hashCode())
        result = 31 * result + (isSigned.hashCode())
        result = 31 * result + (length)
        result = 31 * result + (messageId)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (offset?.hashCode() ?: 0)
        result = 31 * result + (startBit)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CanSignal

        if (factor != other.factor) return false
        if (isBigEndian != other.isBigEndian) return false
        if (isSigned != other.isSigned) return false
        if (length != other.length) return false
        if (messageId != other.messageId) return false
        if (name != other.name) return false
        if (offset != other.offset) return false
        if (startBit != other.startBit) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotfleetwise.model.CanSignal = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A multiplier used to decode the CAN message.
         */
        public var factor: kotlin.Double? = null
        /**
         * Whether the byte ordering of a CAN message is big-endian.
         */
        public var isBigEndian: kotlin.Boolean = false
        /**
         * Whether the message data is specified as a signed value.
         */
        public var isSigned: kotlin.Boolean = false
        /**
         * How many bytes of data are in the message.
         */
        public var length: kotlin.Int = 0
        /**
         * The ID of the message.
         */
        public var messageId: kotlin.Int = 0
        /**
         * The name of the signal.
         */
        public var name: kotlin.String? = null
        /**
         * Indicates where data appears in the CAN message.
         */
        public var offset: kotlin.Double? = null
        /**
         * Indicates the beginning of the CAN message.
         */
        public var startBit: kotlin.Int = 0

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotfleetwise.model.CanSignal) : this() {
            this.factor = x.factor
            this.isBigEndian = x.isBigEndian
            this.isSigned = x.isSigned
            this.length = x.length
            this.messageId = x.messageId
            this.name = x.name
            this.offset = x.offset
            this.startBit = x.startBit
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotfleetwise.model.CanSignal = CanSignal(this)
    }
}
