// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotfleetwise.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a campaign.
 *
 * You can use the API operation to return this information about multiple created campaigns.
 */
public class CampaignSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of a campaign.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The time the campaign was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The description of the campaign.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The last time the campaign was modified.
     */
    public val lastModificationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModificationTime
    /**
     * The name of a campaign.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The ARN of the signal catalog associated with the campaign.
     */
    public val signalCatalogArn: kotlin.String? = builder.signalCatalogArn
    /**
     * The state of a campaign. The status can be one of the following:
     * + `CREATING` - Amazon Web Services IoT FleetWise is processing your request to create the campaign.
     * + `WAITING_FOR_APPROVAL` - After a campaign is created, it enters the `WAITING_FOR_APPROVAL` state. To allow Amazon Web Services IoT FleetWise to deploy the campaign to the target vehicle or fleet, use the API operation to approve the campaign.
     * + `RUNNING` - The campaign is active.
     * + `SUSPENDED` - The campaign is suspended. To resume the campaign, use the API operation.
     */
    public val status: aws.sdk.kotlin.services.iotfleetwise.model.CampaignStatus? = builder.status
    /**
     * The ARN of a vehicle or fleet to which the campaign is deployed.
     */
    public val targetArn: kotlin.String? = builder.targetArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotfleetwise.model.CampaignSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CampaignSummary(")
        append("arn=$arn,")
        append("creationTime=$creationTime,")
        append("description=$description,")
        append("lastModificationTime=$lastModificationTime,")
        append("name=$name,")
        append("signalCatalogArn=$signalCatalogArn,")
        append("status=$status,")
        append("targetArn=$targetArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (lastModificationTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (signalCatalogArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (targetArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CampaignSummary

        if (arn != other.arn) return false
        if (creationTime != other.creationTime) return false
        if (description != other.description) return false
        if (lastModificationTime != other.lastModificationTime) return false
        if (name != other.name) return false
        if (signalCatalogArn != other.signalCatalogArn) return false
        if (status != other.status) return false
        if (targetArn != other.targetArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotfleetwise.model.CampaignSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of a campaign.
         */
        public var arn: kotlin.String? = null
        /**
         * The time the campaign was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the campaign.
         */
        public var description: kotlin.String? = null
        /**
         * The last time the campaign was modified.
         */
        public var lastModificationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of a campaign.
         */
        public var name: kotlin.String? = null
        /**
         * The ARN of the signal catalog associated with the campaign.
         */
        public var signalCatalogArn: kotlin.String? = null
        /**
         * The state of a campaign. The status can be one of the following:
         * + `CREATING` - Amazon Web Services IoT FleetWise is processing your request to create the campaign.
         * + `WAITING_FOR_APPROVAL` - After a campaign is created, it enters the `WAITING_FOR_APPROVAL` state. To allow Amazon Web Services IoT FleetWise to deploy the campaign to the target vehicle or fleet, use the API operation to approve the campaign.
         * + `RUNNING` - The campaign is active.
         * + `SUSPENDED` - The campaign is suspended. To resume the campaign, use the API operation.
         */
        public var status: aws.sdk.kotlin.services.iotfleetwise.model.CampaignStatus? = null
        /**
         * The ARN of a vehicle or fleet to which the campaign is deployed.
         */
        public var targetArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotfleetwise.model.CampaignSummary) : this() {
            this.arn = x.arn
            this.creationTime = x.creationTime
            this.description = x.description
            this.lastModificationTime = x.lastModificationTime
            this.name = x.name
            this.signalCatalogArn = x.signalCatalogArn
            this.status = x.status
            this.targetArn = x.targetArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotfleetwise.model.CampaignSummary = CampaignSummary(this)
    }
}
