// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotfleetwise.model



/**
 * A signal that represents a vehicle device such as the engine, heater, and door locks. Data from an actuator reports the state of a certain vehicle device.
 *
 *  Updating actuator data can change the state of a device. For example, you can turn on or off the heater by updating its actuator data.
 */
public class Actuator private constructor(builder: Builder) {
    /**
     * A list of possible values an actuator can take.
     */
    public val allowedValues: List<String>? = builder.allowedValues
    /**
     * A specified value for the actuator.
     */
    public val assignedValue: kotlin.String? = builder.assignedValue
    /**
     * The specified data type of the actuator.
     */
    public val dataType: aws.sdk.kotlin.services.iotfleetwise.model.NodeDataType? = builder.dataType
    /**
     * A brief description of the actuator.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The fully qualified name of the actuator. For example, the fully qualified name of an actuator might be `Vehicle.Front.Left.Door.Lock`.
     */
    public val fullyQualifiedName: kotlin.String? = builder.fullyQualifiedName
    /**
     * The specified possible maximum value of an actuator.
     */
    public val max: kotlin.Double? = builder.max
    /**
     * The specified possible minimum value of an actuator.
     */
    public val min: kotlin.Double? = builder.min
    /**
     * The scientific unit for the actuator.
     */
    public val unit: kotlin.String? = builder.unit

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.iotfleetwise.model.Actuator = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Actuator(")
        append("allowedValues=$allowedValues,")
        append("assignedValue=$assignedValue,")
        append("dataType=$dataType,")
        append("description=$description,")
        append("fullyQualifiedName=$fullyQualifiedName,")
        append("max=$max,")
        append("min=$min,")
        append("unit=$unit)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowedValues?.hashCode() ?: 0
        result = 31 * result + (assignedValue?.hashCode() ?: 0)
        result = 31 * result + (dataType?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (fullyQualifiedName?.hashCode() ?: 0)
        result = 31 * result + (max?.hashCode() ?: 0)
        result = 31 * result + (min?.hashCode() ?: 0)
        result = 31 * result + (unit?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Actuator

        if (allowedValues != other.allowedValues) return false
        if (assignedValue != other.assignedValue) return false
        if (dataType != other.dataType) return false
        if (description != other.description) return false
        if (fullyQualifiedName != other.fullyQualifiedName) return false
        if (max != other.max) return false
        if (min != other.min) return false
        if (unit != other.unit) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.iotfleetwise.model.Actuator = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of possible values an actuator can take.
         */
        public var allowedValues: List<String>? = null
        /**
         * A specified value for the actuator.
         */
        public var assignedValue: kotlin.String? = null
        /**
         * The specified data type of the actuator.
         */
        public var dataType: aws.sdk.kotlin.services.iotfleetwise.model.NodeDataType? = null
        /**
         * A brief description of the actuator.
         */
        public var description: kotlin.String? = null
        /**
         * The fully qualified name of the actuator. For example, the fully qualified name of an actuator might be `Vehicle.Front.Left.Door.Lock`.
         */
        public var fullyQualifiedName: kotlin.String? = null
        /**
         * The specified possible maximum value of an actuator.
         */
        public var max: kotlin.Double? = null
        /**
         * The specified possible minimum value of an actuator.
         */
        public var min: kotlin.Double? = null
        /**
         * The scientific unit for the actuator.
         */
        public var unit: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.iotfleetwise.model.Actuator) : this() {
            this.allowedValues = x.allowedValues
            this.assignedValue = x.assignedValue
            this.dataType = x.dataType
            this.description = x.description
            this.fullyQualifiedName = x.fullyQualifiedName
            this.max = x.max
            this.min = x.min
            this.unit = x.unit
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.iotfleetwise.model.Actuator = Actuator(this)
    }
}
