// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotfleetwise

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.iotfleetwise.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.iotfleetwise.model.*
import aws.sdk.kotlin.services.iotfleetwise.model.AssociateVehicleFleetRequest
import aws.sdk.kotlin.services.iotfleetwise.model.AssociateVehicleFleetResponse
import aws.sdk.kotlin.services.iotfleetwise.model.BatchCreateVehicleRequest
import aws.sdk.kotlin.services.iotfleetwise.model.BatchCreateVehicleResponse
import aws.sdk.kotlin.services.iotfleetwise.model.BatchUpdateVehicleRequest
import aws.sdk.kotlin.services.iotfleetwise.model.BatchUpdateVehicleResponse
import aws.sdk.kotlin.services.iotfleetwise.model.CreateCampaignRequest
import aws.sdk.kotlin.services.iotfleetwise.model.CreateCampaignResponse
import aws.sdk.kotlin.services.iotfleetwise.model.CreateDecoderManifestRequest
import aws.sdk.kotlin.services.iotfleetwise.model.CreateDecoderManifestResponse
import aws.sdk.kotlin.services.iotfleetwise.model.CreateFleetRequest
import aws.sdk.kotlin.services.iotfleetwise.model.CreateFleetResponse
import aws.sdk.kotlin.services.iotfleetwise.model.CreateModelManifestRequest
import aws.sdk.kotlin.services.iotfleetwise.model.CreateModelManifestResponse
import aws.sdk.kotlin.services.iotfleetwise.model.CreateSignalCatalogRequest
import aws.sdk.kotlin.services.iotfleetwise.model.CreateSignalCatalogResponse
import aws.sdk.kotlin.services.iotfleetwise.model.CreateVehicleRequest
import aws.sdk.kotlin.services.iotfleetwise.model.CreateVehicleResponse
import aws.sdk.kotlin.services.iotfleetwise.model.DeleteCampaignRequest
import aws.sdk.kotlin.services.iotfleetwise.model.DeleteCampaignResponse
import aws.sdk.kotlin.services.iotfleetwise.model.DeleteDecoderManifestRequest
import aws.sdk.kotlin.services.iotfleetwise.model.DeleteDecoderManifestResponse
import aws.sdk.kotlin.services.iotfleetwise.model.DeleteFleetRequest
import aws.sdk.kotlin.services.iotfleetwise.model.DeleteFleetResponse
import aws.sdk.kotlin.services.iotfleetwise.model.DeleteModelManifestRequest
import aws.sdk.kotlin.services.iotfleetwise.model.DeleteModelManifestResponse
import aws.sdk.kotlin.services.iotfleetwise.model.DeleteSignalCatalogRequest
import aws.sdk.kotlin.services.iotfleetwise.model.DeleteSignalCatalogResponse
import aws.sdk.kotlin.services.iotfleetwise.model.DeleteVehicleRequest
import aws.sdk.kotlin.services.iotfleetwise.model.DeleteVehicleResponse
import aws.sdk.kotlin.services.iotfleetwise.model.DisassociateVehicleFleetRequest
import aws.sdk.kotlin.services.iotfleetwise.model.DisassociateVehicleFleetResponse
import aws.sdk.kotlin.services.iotfleetwise.model.GetCampaignRequest
import aws.sdk.kotlin.services.iotfleetwise.model.GetCampaignResponse
import aws.sdk.kotlin.services.iotfleetwise.model.GetDecoderManifestRequest
import aws.sdk.kotlin.services.iotfleetwise.model.GetDecoderManifestResponse
import aws.sdk.kotlin.services.iotfleetwise.model.GetFleetRequest
import aws.sdk.kotlin.services.iotfleetwise.model.GetFleetResponse
import aws.sdk.kotlin.services.iotfleetwise.model.GetLoggingOptionsRequest
import aws.sdk.kotlin.services.iotfleetwise.model.GetLoggingOptionsResponse
import aws.sdk.kotlin.services.iotfleetwise.model.GetModelManifestRequest
import aws.sdk.kotlin.services.iotfleetwise.model.GetModelManifestResponse
import aws.sdk.kotlin.services.iotfleetwise.model.GetRegisterAccountStatusRequest
import aws.sdk.kotlin.services.iotfleetwise.model.GetRegisterAccountStatusResponse
import aws.sdk.kotlin.services.iotfleetwise.model.GetSignalCatalogRequest
import aws.sdk.kotlin.services.iotfleetwise.model.GetSignalCatalogResponse
import aws.sdk.kotlin.services.iotfleetwise.model.GetVehicleRequest
import aws.sdk.kotlin.services.iotfleetwise.model.GetVehicleResponse
import aws.sdk.kotlin.services.iotfleetwise.model.GetVehicleStatusRequest
import aws.sdk.kotlin.services.iotfleetwise.model.GetVehicleStatusResponse
import aws.sdk.kotlin.services.iotfleetwise.model.ImportDecoderManifestRequest
import aws.sdk.kotlin.services.iotfleetwise.model.ImportDecoderManifestResponse
import aws.sdk.kotlin.services.iotfleetwise.model.ImportSignalCatalogRequest
import aws.sdk.kotlin.services.iotfleetwise.model.ImportSignalCatalogResponse
import aws.sdk.kotlin.services.iotfleetwise.model.ListCampaignsRequest
import aws.sdk.kotlin.services.iotfleetwise.model.ListCampaignsResponse
import aws.sdk.kotlin.services.iotfleetwise.model.ListDecoderManifestNetworkInterfacesRequest
import aws.sdk.kotlin.services.iotfleetwise.model.ListDecoderManifestNetworkInterfacesResponse
import aws.sdk.kotlin.services.iotfleetwise.model.ListDecoderManifestSignalsRequest
import aws.sdk.kotlin.services.iotfleetwise.model.ListDecoderManifestSignalsResponse
import aws.sdk.kotlin.services.iotfleetwise.model.ListDecoderManifestsRequest
import aws.sdk.kotlin.services.iotfleetwise.model.ListDecoderManifestsResponse
import aws.sdk.kotlin.services.iotfleetwise.model.ListFleetsForVehicleRequest
import aws.sdk.kotlin.services.iotfleetwise.model.ListFleetsForVehicleResponse
import aws.sdk.kotlin.services.iotfleetwise.model.ListFleetsRequest
import aws.sdk.kotlin.services.iotfleetwise.model.ListFleetsResponse
import aws.sdk.kotlin.services.iotfleetwise.model.ListModelManifestNodesRequest
import aws.sdk.kotlin.services.iotfleetwise.model.ListModelManifestNodesResponse
import aws.sdk.kotlin.services.iotfleetwise.model.ListModelManifestsRequest
import aws.sdk.kotlin.services.iotfleetwise.model.ListModelManifestsResponse
import aws.sdk.kotlin.services.iotfleetwise.model.ListSignalCatalogNodesRequest
import aws.sdk.kotlin.services.iotfleetwise.model.ListSignalCatalogNodesResponse
import aws.sdk.kotlin.services.iotfleetwise.model.ListSignalCatalogsRequest
import aws.sdk.kotlin.services.iotfleetwise.model.ListSignalCatalogsResponse
import aws.sdk.kotlin.services.iotfleetwise.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.iotfleetwise.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.iotfleetwise.model.ListVehiclesInFleetRequest
import aws.sdk.kotlin.services.iotfleetwise.model.ListVehiclesInFleetResponse
import aws.sdk.kotlin.services.iotfleetwise.model.ListVehiclesRequest
import aws.sdk.kotlin.services.iotfleetwise.model.ListVehiclesResponse
import aws.sdk.kotlin.services.iotfleetwise.model.PutLoggingOptionsRequest
import aws.sdk.kotlin.services.iotfleetwise.model.PutLoggingOptionsResponse
import aws.sdk.kotlin.services.iotfleetwise.model.RegisterAccountRequest
import aws.sdk.kotlin.services.iotfleetwise.model.RegisterAccountResponse
import aws.sdk.kotlin.services.iotfleetwise.model.TagResourceRequest
import aws.sdk.kotlin.services.iotfleetwise.model.TagResourceResponse
import aws.sdk.kotlin.services.iotfleetwise.model.UntagResourceRequest
import aws.sdk.kotlin.services.iotfleetwise.model.UntagResourceResponse
import aws.sdk.kotlin.services.iotfleetwise.model.UpdateCampaignRequest
import aws.sdk.kotlin.services.iotfleetwise.model.UpdateCampaignResponse
import aws.sdk.kotlin.services.iotfleetwise.model.UpdateDecoderManifestRequest
import aws.sdk.kotlin.services.iotfleetwise.model.UpdateDecoderManifestResponse
import aws.sdk.kotlin.services.iotfleetwise.model.UpdateFleetRequest
import aws.sdk.kotlin.services.iotfleetwise.model.UpdateFleetResponse
import aws.sdk.kotlin.services.iotfleetwise.model.UpdateModelManifestRequest
import aws.sdk.kotlin.services.iotfleetwise.model.UpdateModelManifestResponse
import aws.sdk.kotlin.services.iotfleetwise.model.UpdateSignalCatalogRequest
import aws.sdk.kotlin.services.iotfleetwise.model.UpdateSignalCatalogResponse
import aws.sdk.kotlin.services.iotfleetwise.model.UpdateVehicleRequest
import aws.sdk.kotlin.services.iotfleetwise.model.UpdateVehicleResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Amazon Web Services IoT FleetWise is a fully managed service that you can use to collect, model, and transfer vehicle data to the Amazon Web Services cloud at scale. With Amazon Web Services IoT FleetWise, you can standardize all of your vehicle data models, independent of the in-vehicle communication architecture, and define data collection rules to transfer only high-value data to the cloud.
 *
 * For more information, see [What is Amazon Web Services IoT FleetWise?](https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/) in the *Amazon Web Services IoT FleetWise Developer Guide*.
 */
public interface IoTFleetWiseClient : SdkClient {

    override val serviceName: String
        get() = "IoTFleetWise"
    /**
     * IoTFleetWiseClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): IoTFleetWiseClient {
            val config = Config.Builder().apply(block).build()
            return DefaultIoTFleetWiseClient(config)
        }

        public operator fun invoke(config: Config): IoTFleetWiseClient = DefaultIoTFleetWiseClient(config)

        /**
         * Construct a [IoTFleetWiseClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): IoTFleetWiseClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultIoTFleetWiseClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Adds, or associates, a vehicle with a fleet.
     */
    public suspend fun associateVehicleFleet(input: AssociateVehicleFleetRequest): AssociateVehicleFleetResponse

    /**
     * Creates a group, or batch, of vehicles.
     *
     *  You must specify a decoder manifest and a vehicle model (model manifest) for each vehicle.
     *
     * For more information, see [Create multiple vehicles (AWS CLI)](https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/create-vehicles-cli.html) in the *Amazon Web Services IoT FleetWise Developer Guide*.
     */
    public suspend fun batchCreateVehicle(input: BatchCreateVehicleRequest): BatchCreateVehicleResponse

    /**
     * Updates a group, or batch, of vehicles.
     *
     *  You must specify a decoder manifest and a vehicle model (model manifest) for each vehicle.
     *
     * For more information, see [Update multiple vehicles (AWS CLI)](https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/update-vehicles-cli.html) in the *Amazon Web Services IoT FleetWise Developer Guide*.
     */
    public suspend fun batchUpdateVehicle(input: BatchUpdateVehicleRequest): BatchUpdateVehicleResponse

    /**
     * Creates an orchestration of data collection rules. The Amazon Web Services IoT FleetWise Edge Agent software running in vehicles uses campaigns to decide how to collect and transfer data to the cloud. You create campaigns in the cloud. After you or your team approve campaigns, Amazon Web Services IoT FleetWise automatically deploys them to vehicles.
     *
     * For more information, see [Collect and transfer data with campaigns](https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/campaigns.html) in the *Amazon Web Services IoT FleetWise Developer Guide*.
     */
    public suspend fun createCampaign(input: CreateCampaignRequest): CreateCampaignResponse

    /**
     * Creates the decoder manifest associated with a model manifest. To create a decoder manifest, the following must be true:
     * + Every signal decoder has a unique name.
     * + Each signal decoder is associated with a network interface.
     * + Each network interface has a unique ID.
     * + The signal decoders are specified in the model manifest.
     */
    public suspend fun createDecoderManifest(input: CreateDecoderManifestRequest): CreateDecoderManifestResponse

    /**
     * Creates a fleet that represents a group of vehicles.
     *
     * You must create both a signal catalog and vehicles before you can create a fleet.
     *
     * For more information, see [Fleets](https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/fleets.html) in the *Amazon Web Services IoT FleetWise Developer Guide*.
     */
    public suspend fun createFleet(input: CreateFleetRequest): CreateFleetResponse

    /**
     * Creates a vehicle model (model manifest) that specifies signals (attributes, branches, sensors, and actuators).
     *
     * For more information, see [Vehicle models](https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/vehicle-models.html) in the *Amazon Web Services IoT FleetWise Developer Guide*.
     */
    public suspend fun createModelManifest(input: CreateModelManifestRequest): CreateModelManifestResponse

    /**
     * Creates a collection of standardized signals that can be reused to create vehicle models.
     */
    public suspend fun createSignalCatalog(input: CreateSignalCatalogRequest): CreateSignalCatalogResponse

    /**
     * Creates a vehicle, which is an instance of a vehicle model (model manifest). Vehicles created from the same vehicle model consist of the same signals inherited from the vehicle model.
     *
     *  If you have an existing Amazon Web Services IoT Thing, you can use Amazon Web Services IoT FleetWise to create a vehicle and collect data from your thing.
     *
     * For more information, see [Create a vehicle (AWS CLI)](https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/create-vehicle-cli.html) in the *Amazon Web Services IoT FleetWise Developer Guide*.
     */
    public suspend fun createVehicle(input: CreateVehicleRequest): CreateVehicleResponse

    /**
     * Deletes a data collection campaign. Deleting a campaign suspends all data collection and removes it from any vehicles.
     */
    public suspend fun deleteCampaign(input: DeleteCampaignRequest): DeleteCampaignResponse

    /**
     * Deletes a decoder manifest. You can't delete a decoder manifest if it has vehicles associated with it.
     *
     * If the decoder manifest is successfully deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200 response with an empty body.
     */
    public suspend fun deleteDecoderManifest(input: DeleteDecoderManifestRequest): DeleteDecoderManifestResponse

    /**
     * Deletes a fleet. Before you delete a fleet, all vehicles must be dissociated from the fleet. For more information, see [Delete a fleet (AWS CLI)](https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/delete-fleet-cli.html) in the *Amazon Web Services IoT FleetWise Developer Guide*.
     *
     * If the fleet is successfully deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200 response with an empty body.
     */
    public suspend fun deleteFleet(input: DeleteFleetRequest): DeleteFleetResponse

    /**
     * Deletes a vehicle model (model manifest).
     *
     * If the vehicle model is successfully deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200 response with an empty body.
     */
    public suspend fun deleteModelManifest(input: DeleteModelManifestRequest): DeleteModelManifestResponse

    /**
     * Deletes a signal catalog.
     *
     * If the signal catalog is successfully deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200 response with an empty body.
     */
    public suspend fun deleteSignalCatalog(input: DeleteSignalCatalogRequest): DeleteSignalCatalogResponse

    /**
     * Deletes a vehicle and removes it from any campaigns.
     *
     * If the vehicle is successfully deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200 response with an empty body.
     */
    public suspend fun deleteVehicle(input: DeleteVehicleRequest): DeleteVehicleResponse

    /**
     * Removes, or disassociates, a vehicle from a fleet. Disassociating a vehicle from a fleet doesn't delete the vehicle.
     *
     * If the vehicle is successfully dissociated from a fleet, Amazon Web Services IoT FleetWise sends back an HTTP 200 response with an empty body.
     */
    public suspend fun disassociateVehicleFleet(input: DisassociateVehicleFleetRequest): DisassociateVehicleFleetResponse

    /**
     * Retrieves information about a campaign.
     */
    public suspend fun getCampaign(input: GetCampaignRequest): GetCampaignResponse

    /**
     * Retrieves information about a created decoder manifest.
     */
    public suspend fun getDecoderManifest(input: GetDecoderManifestRequest): GetDecoderManifestResponse

    /**
     * Retrieves information about a fleet.
     */
    public suspend fun getFleet(input: GetFleetRequest): GetFleetResponse

    /**
     * Retrieves the logging options.
     */
    public suspend fun getLoggingOptions(input: GetLoggingOptionsRequest = GetLoggingOptionsRequest {}): GetLoggingOptionsResponse

    /**
     * Retrieves information about a vehicle model (model manifest).
     */
    public suspend fun getModelManifest(input: GetModelManifestRequest): GetModelManifestResponse

    /**
     * Retrieves information about the status of registering your Amazon Web Services account, IAM, and Amazon Timestream resources so that Amazon Web Services IoT FleetWise can transfer your vehicle data to the Amazon Web Services Cloud.
     *
     * For more information, including step-by-step procedures, see [Setting up Amazon Web Services IoT FleetWise](https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/setting-up.html).
     *
     * This API operation doesn't require input parameters.
     */
    public suspend fun getRegisterAccountStatus(input: GetRegisterAccountStatusRequest = GetRegisterAccountStatusRequest {}): GetRegisterAccountStatusResponse

    /**
     * Retrieves information about a signal catalog.
     */
    public suspend fun getSignalCatalog(input: GetSignalCatalogRequest): GetSignalCatalogResponse

    /**
     * Retrieves information about a vehicle.
     */
    public suspend fun getVehicle(input: GetVehicleRequest): GetVehicleResponse

    /**
     * Retrieves information about the status of a vehicle with any associated campaigns.
     */
    public suspend fun getVehicleStatus(input: GetVehicleStatusRequest): GetVehicleStatusResponse

    /**
     * Creates a decoder manifest using your existing CAN DBC file from your local device.
     */
    public suspend fun importDecoderManifest(input: ImportDecoderManifestRequest): ImportDecoderManifestResponse

    /**
     * Creates a signal catalog using your existing VSS formatted content from your local device.
     */
    public suspend fun importSignalCatalog(input: ImportSignalCatalogRequest): ImportSignalCatalogResponse

    /**
     * Lists information about created campaigns.
     *
     * This API operation uses pagination. Specify the `nextToken` parameter in the request to return more results.
     */
    public suspend fun listCampaigns(input: ListCampaignsRequest = ListCampaignsRequest {}): ListCampaignsResponse

    /**
     * Lists the network interfaces specified in a decoder manifest.
     *
     * This API operation uses pagination. Specify the `nextToken` parameter in the request to return more results.
     */
    public suspend fun listDecoderManifestNetworkInterfaces(input: ListDecoderManifestNetworkInterfacesRequest): ListDecoderManifestNetworkInterfacesResponse

    /**
     * A list of information about signal decoders specified in a decoder manifest.
     *
     * This API operation uses pagination. Specify the `nextToken` parameter in the request to return more results.
     */
    public suspend fun listDecoderManifestSignals(input: ListDecoderManifestSignalsRequest): ListDecoderManifestSignalsResponse

    /**
     * Lists decoder manifests.
     *
     * This API operation uses pagination. Specify the `nextToken` parameter in the request to return more results.
     */
    public suspend fun listDecoderManifests(input: ListDecoderManifestsRequest = ListDecoderManifestsRequest {}): ListDecoderManifestsResponse

    /**
     * Retrieves information for each created fleet in an Amazon Web Services account.
     *
     * This API operation uses pagination. Specify the `nextToken` parameter in the request to return more results.
     */
    public suspend fun listFleets(input: ListFleetsRequest = ListFleetsRequest {}): ListFleetsResponse

    /**
     * Retrieves a list of IDs for all fleets that the vehicle is associated with.
     *
     * This API operation uses pagination. Specify the `nextToken` parameter in the request to return more results.
     */
    public suspend fun listFleetsForVehicle(input: ListFleetsForVehicleRequest): ListFleetsForVehicleResponse

    /**
     * Lists information about nodes specified in a vehicle model (model manifest).
     *
     * This API operation uses pagination. Specify the `nextToken` parameter in the request to return more results.
     */
    public suspend fun listModelManifestNodes(input: ListModelManifestNodesRequest): ListModelManifestNodesResponse

    /**
     * Retrieves a list of vehicle models (model manifests).
     *
     * This API operation uses pagination. Specify the `nextToken` parameter in the request to return more results.
     */
    public suspend fun listModelManifests(input: ListModelManifestsRequest = ListModelManifestsRequest {}): ListModelManifestsResponse

    /**
     * Lists of information about the signals (nodes) specified in a signal catalog.
     *
     * This API operation uses pagination. Specify the `nextToken` parameter in the request to return more results.
     */
    public suspend fun listSignalCatalogNodes(input: ListSignalCatalogNodesRequest): ListSignalCatalogNodesResponse

    /**
     * Lists all the created signal catalogs in an Amazon Web Services account.
     *
     * You can use to list information about each signal (node) specified in a signal catalog.
     *
     * This API operation uses pagination. Specify the `nextToken` parameter in the request to return more results.
     */
    public suspend fun listSignalCatalogs(input: ListSignalCatalogsRequest = ListSignalCatalogsRequest {}): ListSignalCatalogsResponse

    /**
     * Lists the tags (metadata) you have assigned to the resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Retrieves a list of summaries of created vehicles.
     *
     * This API operation uses pagination. Specify the `nextToken` parameter in the request to return more results.
     */
    public suspend fun listVehicles(input: ListVehiclesRequest = ListVehiclesRequest {}): ListVehiclesResponse

    /**
     * Retrieves a list of summaries of all vehicles associated with a fleet.
     *
     * This API operation uses pagination. Specify the `nextToken` parameter in the request to return more results.
     */
    public suspend fun listVehiclesInFleet(input: ListVehiclesInFleetRequest): ListVehiclesInFleetResponse

    /**
     * Creates or updates the logging option.
     */
    public suspend fun putLoggingOptions(input: PutLoggingOptionsRequest): PutLoggingOptionsResponse

    /**
     * Registers your Amazon Web Services account, IAM, and Amazon Timestream resources so Amazon Web Services IoT FleetWise can transfer your vehicle data to the Amazon Web Services Cloud. For more information, including step-by-step procedures, see [Setting up Amazon Web Services IoT FleetWise](https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/setting-up.html).
     *
     * An Amazon Web Services account is **not** the same thing as a "user account". An [Amazon Web Services user](https://docs.aws.amazon.com/IAM/latest/UserGuide/introduction_identity-management.html#intro-identity-users) is an identity that you create using Identity and Access Management (IAM) and takes the form of either an [IAM user](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users.html) or an [IAM role, both with credentials](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html). A single Amazon Web Services account can, and typically does, contain many users and roles.
     */
    public suspend fun registerAccount(input: RegisterAccountRequest): RegisterAccountResponse

    /**
     * Adds to or modifies the tags of the given resource. Tags are metadata which can be used to manage a resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes the given tags (metadata) from the resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates a campaign.
     */
    public suspend fun updateCampaign(input: UpdateCampaignRequest): UpdateCampaignResponse

    /**
     * Updates a decoder manifest.
     *
     * A decoder manifest can only be updated when the status is `DRAFT`. Only `ACTIVE` decoder manifests can be associated with vehicles.
     */
    public suspend fun updateDecoderManifest(input: UpdateDecoderManifestRequest): UpdateDecoderManifestResponse

    /**
     * Updates the description of an existing fleet.
     *
     * If the fleet is successfully updated, Amazon Web Services IoT FleetWise sends back an HTTP 200 response with an empty HTTP body.
     */
    public suspend fun updateFleet(input: UpdateFleetRequest): UpdateFleetResponse

    /**
     * Updates a vehicle model (model manifest). If created vehicles are associated with a vehicle model, it can't be updated.
     */
    public suspend fun updateModelManifest(input: UpdateModelManifestRequest): UpdateModelManifestResponse

    /**
     * Updates a signal catalog.
     */
    public suspend fun updateSignalCatalog(input: UpdateSignalCatalogRequest): UpdateSignalCatalogResponse

    /**
     * Updates a vehicle.
     */
    public suspend fun updateVehicle(input: UpdateVehicleRequest): UpdateVehicleResponse
}

/**
 * Adds, or associates, a vehicle with a fleet.
 */
public suspend inline fun IoTFleetWiseClient.associateVehicleFleet(crossinline block: AssociateVehicleFleetRequest.Builder.() -> Unit): AssociateVehicleFleetResponse = associateVehicleFleet(AssociateVehicleFleetRequest.Builder().apply(block).build())

/**
 * Creates a group, or batch, of vehicles.
 *
 *  You must specify a decoder manifest and a vehicle model (model manifest) for each vehicle.
 *
 * For more information, see [Create multiple vehicles (AWS CLI)](https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/create-vehicles-cli.html) in the *Amazon Web Services IoT FleetWise Developer Guide*.
 */
public suspend inline fun IoTFleetWiseClient.batchCreateVehicle(crossinline block: BatchCreateVehicleRequest.Builder.() -> Unit): BatchCreateVehicleResponse = batchCreateVehicle(BatchCreateVehicleRequest.Builder().apply(block).build())

/**
 * Updates a group, or batch, of vehicles.
 *
 *  You must specify a decoder manifest and a vehicle model (model manifest) for each vehicle.
 *
 * For more information, see [Update multiple vehicles (AWS CLI)](https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/update-vehicles-cli.html) in the *Amazon Web Services IoT FleetWise Developer Guide*.
 */
public suspend inline fun IoTFleetWiseClient.batchUpdateVehicle(crossinline block: BatchUpdateVehicleRequest.Builder.() -> Unit): BatchUpdateVehicleResponse = batchUpdateVehicle(BatchUpdateVehicleRequest.Builder().apply(block).build())

/**
 * Creates an orchestration of data collection rules. The Amazon Web Services IoT FleetWise Edge Agent software running in vehicles uses campaigns to decide how to collect and transfer data to the cloud. You create campaigns in the cloud. After you or your team approve campaigns, Amazon Web Services IoT FleetWise automatically deploys them to vehicles.
 *
 * For more information, see [Collect and transfer data with campaigns](https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/campaigns.html) in the *Amazon Web Services IoT FleetWise Developer Guide*.
 */
public suspend inline fun IoTFleetWiseClient.createCampaign(crossinline block: CreateCampaignRequest.Builder.() -> Unit): CreateCampaignResponse = createCampaign(CreateCampaignRequest.Builder().apply(block).build())

/**
 * Creates the decoder manifest associated with a model manifest. To create a decoder manifest, the following must be true:
 * + Every signal decoder has a unique name.
 * + Each signal decoder is associated with a network interface.
 * + Each network interface has a unique ID.
 * + The signal decoders are specified in the model manifest.
 */
public suspend inline fun IoTFleetWiseClient.createDecoderManifest(crossinline block: CreateDecoderManifestRequest.Builder.() -> Unit): CreateDecoderManifestResponse = createDecoderManifest(CreateDecoderManifestRequest.Builder().apply(block).build())

/**
 * Creates a fleet that represents a group of vehicles.
 *
 * You must create both a signal catalog and vehicles before you can create a fleet.
 *
 * For more information, see [Fleets](https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/fleets.html) in the *Amazon Web Services IoT FleetWise Developer Guide*.
 */
public suspend inline fun IoTFleetWiseClient.createFleet(crossinline block: CreateFleetRequest.Builder.() -> Unit): CreateFleetResponse = createFleet(CreateFleetRequest.Builder().apply(block).build())

/**
 * Creates a vehicle model (model manifest) that specifies signals (attributes, branches, sensors, and actuators).
 *
 * For more information, see [Vehicle models](https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/vehicle-models.html) in the *Amazon Web Services IoT FleetWise Developer Guide*.
 */
public suspend inline fun IoTFleetWiseClient.createModelManifest(crossinline block: CreateModelManifestRequest.Builder.() -> Unit): CreateModelManifestResponse = createModelManifest(CreateModelManifestRequest.Builder().apply(block).build())

/**
 * Creates a collection of standardized signals that can be reused to create vehicle models.
 */
public suspend inline fun IoTFleetWiseClient.createSignalCatalog(crossinline block: CreateSignalCatalogRequest.Builder.() -> Unit): CreateSignalCatalogResponse = createSignalCatalog(CreateSignalCatalogRequest.Builder().apply(block).build())

/**
 * Creates a vehicle, which is an instance of a vehicle model (model manifest). Vehicles created from the same vehicle model consist of the same signals inherited from the vehicle model.
 *
 *  If you have an existing Amazon Web Services IoT Thing, you can use Amazon Web Services IoT FleetWise to create a vehicle and collect data from your thing.
 *
 * For more information, see [Create a vehicle (AWS CLI)](https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/create-vehicle-cli.html) in the *Amazon Web Services IoT FleetWise Developer Guide*.
 */
public suspend inline fun IoTFleetWiseClient.createVehicle(crossinline block: CreateVehicleRequest.Builder.() -> Unit): CreateVehicleResponse = createVehicle(CreateVehicleRequest.Builder().apply(block).build())

/**
 * Deletes a data collection campaign. Deleting a campaign suspends all data collection and removes it from any vehicles.
 */
public suspend inline fun IoTFleetWiseClient.deleteCampaign(crossinline block: DeleteCampaignRequest.Builder.() -> Unit): DeleteCampaignResponse = deleteCampaign(DeleteCampaignRequest.Builder().apply(block).build())

/**
 * Deletes a decoder manifest. You can't delete a decoder manifest if it has vehicles associated with it.
 *
 * If the decoder manifest is successfully deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200 response with an empty body.
 */
public suspend inline fun IoTFleetWiseClient.deleteDecoderManifest(crossinline block: DeleteDecoderManifestRequest.Builder.() -> Unit): DeleteDecoderManifestResponse = deleteDecoderManifest(DeleteDecoderManifestRequest.Builder().apply(block).build())

/**
 * Deletes a fleet. Before you delete a fleet, all vehicles must be dissociated from the fleet. For more information, see [Delete a fleet (AWS CLI)](https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/delete-fleet-cli.html) in the *Amazon Web Services IoT FleetWise Developer Guide*.
 *
 * If the fleet is successfully deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200 response with an empty body.
 */
public suspend inline fun IoTFleetWiseClient.deleteFleet(crossinline block: DeleteFleetRequest.Builder.() -> Unit): DeleteFleetResponse = deleteFleet(DeleteFleetRequest.Builder().apply(block).build())

/**
 * Deletes a vehicle model (model manifest).
 *
 * If the vehicle model is successfully deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200 response with an empty body.
 */
public suspend inline fun IoTFleetWiseClient.deleteModelManifest(crossinline block: DeleteModelManifestRequest.Builder.() -> Unit): DeleteModelManifestResponse = deleteModelManifest(DeleteModelManifestRequest.Builder().apply(block).build())

/**
 * Deletes a signal catalog.
 *
 * If the signal catalog is successfully deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200 response with an empty body.
 */
public suspend inline fun IoTFleetWiseClient.deleteSignalCatalog(crossinline block: DeleteSignalCatalogRequest.Builder.() -> Unit): DeleteSignalCatalogResponse = deleteSignalCatalog(DeleteSignalCatalogRequest.Builder().apply(block).build())

/**
 * Deletes a vehicle and removes it from any campaigns.
 *
 * If the vehicle is successfully deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200 response with an empty body.
 */
public suspend inline fun IoTFleetWiseClient.deleteVehicle(crossinline block: DeleteVehicleRequest.Builder.() -> Unit): DeleteVehicleResponse = deleteVehicle(DeleteVehicleRequest.Builder().apply(block).build())

/**
 * Removes, or disassociates, a vehicle from a fleet. Disassociating a vehicle from a fleet doesn't delete the vehicle.
 *
 * If the vehicle is successfully dissociated from a fleet, Amazon Web Services IoT FleetWise sends back an HTTP 200 response with an empty body.
 */
public suspend inline fun IoTFleetWiseClient.disassociateVehicleFleet(crossinline block: DisassociateVehicleFleetRequest.Builder.() -> Unit): DisassociateVehicleFleetResponse = disassociateVehicleFleet(DisassociateVehicleFleetRequest.Builder().apply(block).build())

/**
 * Retrieves information about a campaign.
 */
public suspend inline fun IoTFleetWiseClient.getCampaign(crossinline block: GetCampaignRequest.Builder.() -> Unit): GetCampaignResponse = getCampaign(GetCampaignRequest.Builder().apply(block).build())

/**
 * Retrieves information about a created decoder manifest.
 */
public suspend inline fun IoTFleetWiseClient.getDecoderManifest(crossinline block: GetDecoderManifestRequest.Builder.() -> Unit): GetDecoderManifestResponse = getDecoderManifest(GetDecoderManifestRequest.Builder().apply(block).build())

/**
 * Retrieves information about a fleet.
 */
public suspend inline fun IoTFleetWiseClient.getFleet(crossinline block: GetFleetRequest.Builder.() -> Unit): GetFleetResponse = getFleet(GetFleetRequest.Builder().apply(block).build())

/**
 * Retrieves the logging options.
 */
public suspend inline fun IoTFleetWiseClient.getLoggingOptions(crossinline block: GetLoggingOptionsRequest.Builder.() -> Unit): GetLoggingOptionsResponse = getLoggingOptions(GetLoggingOptionsRequest.Builder().apply(block).build())

/**
 * Retrieves information about a vehicle model (model manifest).
 */
public suspend inline fun IoTFleetWiseClient.getModelManifest(crossinline block: GetModelManifestRequest.Builder.() -> Unit): GetModelManifestResponse = getModelManifest(GetModelManifestRequest.Builder().apply(block).build())

/**
 * Retrieves information about the status of registering your Amazon Web Services account, IAM, and Amazon Timestream resources so that Amazon Web Services IoT FleetWise can transfer your vehicle data to the Amazon Web Services Cloud.
 *
 * For more information, including step-by-step procedures, see [Setting up Amazon Web Services IoT FleetWise](https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/setting-up.html).
 *
 * This API operation doesn't require input parameters.
 */
public suspend inline fun IoTFleetWiseClient.getRegisterAccountStatus(crossinline block: GetRegisterAccountStatusRequest.Builder.() -> Unit): GetRegisterAccountStatusResponse = getRegisterAccountStatus(GetRegisterAccountStatusRequest.Builder().apply(block).build())

/**
 * Retrieves information about a signal catalog.
 */
public suspend inline fun IoTFleetWiseClient.getSignalCatalog(crossinline block: GetSignalCatalogRequest.Builder.() -> Unit): GetSignalCatalogResponse = getSignalCatalog(GetSignalCatalogRequest.Builder().apply(block).build())

/**
 * Retrieves information about a vehicle.
 */
public suspend inline fun IoTFleetWiseClient.getVehicle(crossinline block: GetVehicleRequest.Builder.() -> Unit): GetVehicleResponse = getVehicle(GetVehicleRequest.Builder().apply(block).build())

/**
 * Retrieves information about the status of a vehicle with any associated campaigns.
 */
public suspend inline fun IoTFleetWiseClient.getVehicleStatus(crossinline block: GetVehicleStatusRequest.Builder.() -> Unit): GetVehicleStatusResponse = getVehicleStatus(GetVehicleStatusRequest.Builder().apply(block).build())

/**
 * Creates a decoder manifest using your existing CAN DBC file from your local device.
 */
public suspend inline fun IoTFleetWiseClient.importDecoderManifest(crossinline block: ImportDecoderManifestRequest.Builder.() -> Unit): ImportDecoderManifestResponse = importDecoderManifest(ImportDecoderManifestRequest.Builder().apply(block).build())

/**
 * Creates a signal catalog using your existing VSS formatted content from your local device.
 */
public suspend inline fun IoTFleetWiseClient.importSignalCatalog(crossinline block: ImportSignalCatalogRequest.Builder.() -> Unit): ImportSignalCatalogResponse = importSignalCatalog(ImportSignalCatalogRequest.Builder().apply(block).build())

/**
 * Lists information about created campaigns.
 *
 * This API operation uses pagination. Specify the `nextToken` parameter in the request to return more results.
 */
public suspend inline fun IoTFleetWiseClient.listCampaigns(crossinline block: ListCampaignsRequest.Builder.() -> Unit): ListCampaignsResponse = listCampaigns(ListCampaignsRequest.Builder().apply(block).build())

/**
 * Lists the network interfaces specified in a decoder manifest.
 *
 * This API operation uses pagination. Specify the `nextToken` parameter in the request to return more results.
 */
public suspend inline fun IoTFleetWiseClient.listDecoderManifestNetworkInterfaces(crossinline block: ListDecoderManifestNetworkInterfacesRequest.Builder.() -> Unit): ListDecoderManifestNetworkInterfacesResponse = listDecoderManifestNetworkInterfaces(ListDecoderManifestNetworkInterfacesRequest.Builder().apply(block).build())

/**
 * A list of information about signal decoders specified in a decoder manifest.
 *
 * This API operation uses pagination. Specify the `nextToken` parameter in the request to return more results.
 */
public suspend inline fun IoTFleetWiseClient.listDecoderManifestSignals(crossinline block: ListDecoderManifestSignalsRequest.Builder.() -> Unit): ListDecoderManifestSignalsResponse = listDecoderManifestSignals(ListDecoderManifestSignalsRequest.Builder().apply(block).build())

/**
 * Lists decoder manifests.
 *
 * This API operation uses pagination. Specify the `nextToken` parameter in the request to return more results.
 */
public suspend inline fun IoTFleetWiseClient.listDecoderManifests(crossinline block: ListDecoderManifestsRequest.Builder.() -> Unit): ListDecoderManifestsResponse = listDecoderManifests(ListDecoderManifestsRequest.Builder().apply(block).build())

/**
 * Retrieves information for each created fleet in an Amazon Web Services account.
 *
 * This API operation uses pagination. Specify the `nextToken` parameter in the request to return more results.
 */
public suspend inline fun IoTFleetWiseClient.listFleets(crossinline block: ListFleetsRequest.Builder.() -> Unit): ListFleetsResponse = listFleets(ListFleetsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of IDs for all fleets that the vehicle is associated with.
 *
 * This API operation uses pagination. Specify the `nextToken` parameter in the request to return more results.
 */
public suspend inline fun IoTFleetWiseClient.listFleetsForVehicle(crossinline block: ListFleetsForVehicleRequest.Builder.() -> Unit): ListFleetsForVehicleResponse = listFleetsForVehicle(ListFleetsForVehicleRequest.Builder().apply(block).build())

/**
 * Lists information about nodes specified in a vehicle model (model manifest).
 *
 * This API operation uses pagination. Specify the `nextToken` parameter in the request to return more results.
 */
public suspend inline fun IoTFleetWiseClient.listModelManifestNodes(crossinline block: ListModelManifestNodesRequest.Builder.() -> Unit): ListModelManifestNodesResponse = listModelManifestNodes(ListModelManifestNodesRequest.Builder().apply(block).build())

/**
 * Retrieves a list of vehicle models (model manifests).
 *
 * This API operation uses pagination. Specify the `nextToken` parameter in the request to return more results.
 */
public suspend inline fun IoTFleetWiseClient.listModelManifests(crossinline block: ListModelManifestsRequest.Builder.() -> Unit): ListModelManifestsResponse = listModelManifests(ListModelManifestsRequest.Builder().apply(block).build())

/**
 * Lists of information about the signals (nodes) specified in a signal catalog.
 *
 * This API operation uses pagination. Specify the `nextToken` parameter in the request to return more results.
 */
public suspend inline fun IoTFleetWiseClient.listSignalCatalogNodes(crossinline block: ListSignalCatalogNodesRequest.Builder.() -> Unit): ListSignalCatalogNodesResponse = listSignalCatalogNodes(ListSignalCatalogNodesRequest.Builder().apply(block).build())

/**
 * Lists all the created signal catalogs in an Amazon Web Services account.
 *
 * You can use to list information about each signal (node) specified in a signal catalog.
 *
 * This API operation uses pagination. Specify the `nextToken` parameter in the request to return more results.
 */
public suspend inline fun IoTFleetWiseClient.listSignalCatalogs(crossinline block: ListSignalCatalogsRequest.Builder.() -> Unit): ListSignalCatalogsResponse = listSignalCatalogs(ListSignalCatalogsRequest.Builder().apply(block).build())

/**
 * Lists the tags (metadata) you have assigned to the resource.
 */
public suspend inline fun IoTFleetWiseClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Retrieves a list of summaries of created vehicles.
 *
 * This API operation uses pagination. Specify the `nextToken` parameter in the request to return more results.
 */
public suspend inline fun IoTFleetWiseClient.listVehicles(crossinline block: ListVehiclesRequest.Builder.() -> Unit): ListVehiclesResponse = listVehicles(ListVehiclesRequest.Builder().apply(block).build())

/**
 * Retrieves a list of summaries of all vehicles associated with a fleet.
 *
 * This API operation uses pagination. Specify the `nextToken` parameter in the request to return more results.
 */
public suspend inline fun IoTFleetWiseClient.listVehiclesInFleet(crossinline block: ListVehiclesInFleetRequest.Builder.() -> Unit): ListVehiclesInFleetResponse = listVehiclesInFleet(ListVehiclesInFleetRequest.Builder().apply(block).build())

/**
 * Creates or updates the logging option.
 */
public suspend inline fun IoTFleetWiseClient.putLoggingOptions(crossinline block: PutLoggingOptionsRequest.Builder.() -> Unit): PutLoggingOptionsResponse = putLoggingOptions(PutLoggingOptionsRequest.Builder().apply(block).build())

/**
 * Registers your Amazon Web Services account, IAM, and Amazon Timestream resources so Amazon Web Services IoT FleetWise can transfer your vehicle data to the Amazon Web Services Cloud. For more information, including step-by-step procedures, see [Setting up Amazon Web Services IoT FleetWise](https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/setting-up.html).
 *
 * An Amazon Web Services account is **not** the same thing as a "user account". An [Amazon Web Services user](https://docs.aws.amazon.com/IAM/latest/UserGuide/introduction_identity-management.html#intro-identity-users) is an identity that you create using Identity and Access Management (IAM) and takes the form of either an [IAM user](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users.html) or an [IAM role, both with credentials](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html). A single Amazon Web Services account can, and typically does, contain many users and roles.
 */
public suspend inline fun IoTFleetWiseClient.registerAccount(crossinline block: RegisterAccountRequest.Builder.() -> Unit): RegisterAccountResponse = registerAccount(RegisterAccountRequest.Builder().apply(block).build())

/**
 * Adds to or modifies the tags of the given resource. Tags are metadata which can be used to manage a resource.
 */
public suspend inline fun IoTFleetWiseClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes the given tags (metadata) from the resource.
 */
public suspend inline fun IoTFleetWiseClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates a campaign.
 */
public suspend inline fun IoTFleetWiseClient.updateCampaign(crossinline block: UpdateCampaignRequest.Builder.() -> Unit): UpdateCampaignResponse = updateCampaign(UpdateCampaignRequest.Builder().apply(block).build())

/**
 * Updates a decoder manifest.
 *
 * A decoder manifest can only be updated when the status is `DRAFT`. Only `ACTIVE` decoder manifests can be associated with vehicles.
 */
public suspend inline fun IoTFleetWiseClient.updateDecoderManifest(crossinline block: UpdateDecoderManifestRequest.Builder.() -> Unit): UpdateDecoderManifestResponse = updateDecoderManifest(UpdateDecoderManifestRequest.Builder().apply(block).build())

/**
 * Updates the description of an existing fleet.
 *
 * If the fleet is successfully updated, Amazon Web Services IoT FleetWise sends back an HTTP 200 response with an empty HTTP body.
 */
public suspend inline fun IoTFleetWiseClient.updateFleet(crossinline block: UpdateFleetRequest.Builder.() -> Unit): UpdateFleetResponse = updateFleet(UpdateFleetRequest.Builder().apply(block).build())

/**
 * Updates a vehicle model (model manifest). If created vehicles are associated with a vehicle model, it can't be updated.
 */
public suspend inline fun IoTFleetWiseClient.updateModelManifest(crossinline block: UpdateModelManifestRequest.Builder.() -> Unit): UpdateModelManifestResponse = updateModelManifest(UpdateModelManifestRequest.Builder().apply(block).build())

/**
 * Updates a signal catalog.
 */
public suspend inline fun IoTFleetWiseClient.updateSignalCatalog(crossinline block: UpdateSignalCatalogRequest.Builder.() -> Unit): UpdateSignalCatalogResponse = updateSignalCatalog(UpdateSignalCatalogRequest.Builder().apply(block).build())

/**
 * Updates a vehicle.
 */
public suspend inline fun IoTFleetWiseClient.updateVehicle(crossinline block: UpdateVehicleRequest.Builder.() -> Unit): UpdateVehicleResponse = updateVehicle(UpdateVehicleRequest.Builder().apply(block).build())
