// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotfleetwise

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.runtime.protocol.json.AwsJsonProtocol
import aws.sdk.kotlin.services.iotfleetwise.model.*
import aws.sdk.kotlin.services.iotfleetwise.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "IoTFleetWise"
public const val ServiceApiVersion: String = "2021-06-17"
public const val SdkVersion: String = "0.17.10-beta"

internal class DefaultIoTFleetWiseClient(override val config: IoTFleetWiseClient.Config) : IoTFleetWiseClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Adds, or associates, a vehicle with a fleet.
     */
    override suspend fun associateVehicleFleet(input: AssociateVehicleFleetRequest): AssociateVehicleFleetResponse {
        val op = SdkHttpOperation.build<AssociateVehicleFleetRequest, AssociateVehicleFleetResponse> {
            serializer = AssociateVehicleFleetOperationSerializer()
            deserializer = AssociateVehicleFleetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AssociateVehicleFleet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IoTAutobahnControlPlane", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleetwise"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a group, or batch, of vehicles.
     *
     *  You must specify a decoder manifest and a vehicle model (model manifest) for each vehicle.
     *
     * For more information, see [Create multiple vehicles (AWS CLI)](https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/create-vehicles-cli.html) in the *Amazon Web Services IoT FleetWise Developer Guide*.
     */
    override suspend fun batchCreateVehicle(input: BatchCreateVehicleRequest): BatchCreateVehicleResponse {
        val op = SdkHttpOperation.build<BatchCreateVehicleRequest, BatchCreateVehicleResponse> {
            serializer = BatchCreateVehicleOperationSerializer()
            deserializer = BatchCreateVehicleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchCreateVehicle"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IoTAutobahnControlPlane", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleetwise"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a group, or batch, of vehicles.
     *
     *  You must specify a decoder manifest and a vehicle model (model manifest) for each vehicle.
     *
     * For more information, see [Update multiple vehicles (AWS CLI)](https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/update-vehicles-cli.html) in the *Amazon Web Services IoT FleetWise Developer Guide*.
     */
    override suspend fun batchUpdateVehicle(input: BatchUpdateVehicleRequest): BatchUpdateVehicleResponse {
        val op = SdkHttpOperation.build<BatchUpdateVehicleRequest, BatchUpdateVehicleResponse> {
            serializer = BatchUpdateVehicleOperationSerializer()
            deserializer = BatchUpdateVehicleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchUpdateVehicle"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IoTAutobahnControlPlane", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleetwise"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates an orchestration of data collection rules. The Amazon Web Services IoT FleetWise Edge Agent software running in vehicles uses campaigns to decide how to collect and transfer data to the cloud. You create campaigns in the cloud. After you or your team approve campaigns, Amazon Web Services IoT FleetWise automatically deploys them to vehicles.
     *
     * For more information, see [Collect and transfer data with campaigns](https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/campaigns.html) in the *Amazon Web Services IoT FleetWise Developer Guide*.
     */
    override suspend fun createCampaign(input: CreateCampaignRequest): CreateCampaignResponse {
        val op = SdkHttpOperation.build<CreateCampaignRequest, CreateCampaignResponse> {
            serializer = CreateCampaignOperationSerializer()
            deserializer = CreateCampaignOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateCampaign"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IoTAutobahnControlPlane", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleetwise"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates the decoder manifest associated with a model manifest. To create a decoder manifest, the following must be true:
     * + Every signal decoder has a unique name.
     * + Each signal decoder is associated with a network interface.
     * + Each network interface has a unique ID.
     * + The signal decoders are specified in the model manifest.
     */
    override suspend fun createDecoderManifest(input: CreateDecoderManifestRequest): CreateDecoderManifestResponse {
        val op = SdkHttpOperation.build<CreateDecoderManifestRequest, CreateDecoderManifestResponse> {
            serializer = CreateDecoderManifestOperationSerializer()
            deserializer = CreateDecoderManifestOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDecoderManifest"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IoTAutobahnControlPlane", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleetwise"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a fleet that represents a group of vehicles.
     *
     * You must create both a signal catalog and vehicles before you can create a fleet.
     *
     * For more information, see [Fleets](https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/fleets.html) in the *Amazon Web Services IoT FleetWise Developer Guide*.
     */
    override suspend fun createFleet(input: CreateFleetRequest): CreateFleetResponse {
        val op = SdkHttpOperation.build<CreateFleetRequest, CreateFleetResponse> {
            serializer = CreateFleetOperationSerializer()
            deserializer = CreateFleetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateFleet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IoTAutobahnControlPlane", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleetwise"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a vehicle model (model manifest) that specifies signals (attributes, branches, sensors, and actuators).
     *
     * For more information, see [Vehicle models](https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/vehicle-models.html) in the *Amazon Web Services IoT FleetWise Developer Guide*.
     */
    override suspend fun createModelManifest(input: CreateModelManifestRequest): CreateModelManifestResponse {
        val op = SdkHttpOperation.build<CreateModelManifestRequest, CreateModelManifestResponse> {
            serializer = CreateModelManifestOperationSerializer()
            deserializer = CreateModelManifestOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateModelManifest"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IoTAutobahnControlPlane", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleetwise"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a collection of standardized signals that can be reused to create vehicle models.
     */
    override suspend fun createSignalCatalog(input: CreateSignalCatalogRequest): CreateSignalCatalogResponse {
        val op = SdkHttpOperation.build<CreateSignalCatalogRequest, CreateSignalCatalogResponse> {
            serializer = CreateSignalCatalogOperationSerializer()
            deserializer = CreateSignalCatalogOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateSignalCatalog"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IoTAutobahnControlPlane", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleetwise"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a vehicle, which is an instance of a vehicle model (model manifest). Vehicles created from the same vehicle model consist of the same signals inherited from the vehicle model.
     *
     *  If you have an existing Amazon Web Services IoT Thing, you can use Amazon Web Services IoT FleetWise to create a vehicle and collect data from your thing.
     *
     * For more information, see [Create a vehicle (AWS CLI)](https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/create-vehicle-cli.html) in the *Amazon Web Services IoT FleetWise Developer Guide*.
     */
    override suspend fun createVehicle(input: CreateVehicleRequest): CreateVehicleResponse {
        val op = SdkHttpOperation.build<CreateVehicleRequest, CreateVehicleResponse> {
            serializer = CreateVehicleOperationSerializer()
            deserializer = CreateVehicleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateVehicle"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IoTAutobahnControlPlane", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleetwise"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a data collection campaign. Deleting a campaign suspends all data collection and removes it from any vehicles.
     */
    override suspend fun deleteCampaign(input: DeleteCampaignRequest): DeleteCampaignResponse {
        val op = SdkHttpOperation.build<DeleteCampaignRequest, DeleteCampaignResponse> {
            serializer = DeleteCampaignOperationSerializer()
            deserializer = DeleteCampaignOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteCampaign"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IoTAutobahnControlPlane", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleetwise"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a decoder manifest. You can't delete a decoder manifest if it has vehicles associated with it.
     *
     * If the decoder manifest is successfully deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200 response with an empty body.
     */
    override suspend fun deleteDecoderManifest(input: DeleteDecoderManifestRequest): DeleteDecoderManifestResponse {
        val op = SdkHttpOperation.build<DeleteDecoderManifestRequest, DeleteDecoderManifestResponse> {
            serializer = DeleteDecoderManifestOperationSerializer()
            deserializer = DeleteDecoderManifestOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteDecoderManifest"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IoTAutobahnControlPlane", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleetwise"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a fleet. Before you delete a fleet, all vehicles must be dissociated from the fleet. For more information, see [Delete a fleet (AWS CLI)](https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/delete-fleet-cli.html) in the *Amazon Web Services IoT FleetWise Developer Guide*.
     *
     * If the fleet is successfully deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200 response with an empty body.
     */
    override suspend fun deleteFleet(input: DeleteFleetRequest): DeleteFleetResponse {
        val op = SdkHttpOperation.build<DeleteFleetRequest, DeleteFleetResponse> {
            serializer = DeleteFleetOperationSerializer()
            deserializer = DeleteFleetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteFleet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IoTAutobahnControlPlane", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleetwise"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a vehicle model (model manifest).
     *
     * If the vehicle model is successfully deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200 response with an empty body.
     */
    override suspend fun deleteModelManifest(input: DeleteModelManifestRequest): DeleteModelManifestResponse {
        val op = SdkHttpOperation.build<DeleteModelManifestRequest, DeleteModelManifestResponse> {
            serializer = DeleteModelManifestOperationSerializer()
            deserializer = DeleteModelManifestOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteModelManifest"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IoTAutobahnControlPlane", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleetwise"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a signal catalog.
     *
     * If the signal catalog is successfully deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200 response with an empty body.
     */
    override suspend fun deleteSignalCatalog(input: DeleteSignalCatalogRequest): DeleteSignalCatalogResponse {
        val op = SdkHttpOperation.build<DeleteSignalCatalogRequest, DeleteSignalCatalogResponse> {
            serializer = DeleteSignalCatalogOperationSerializer()
            deserializer = DeleteSignalCatalogOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteSignalCatalog"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IoTAutobahnControlPlane", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleetwise"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a vehicle and removes it from any campaigns.
     *
     * If the vehicle is successfully deleted, Amazon Web Services IoT FleetWise sends back an HTTP 200 response with an empty body.
     */
    override suspend fun deleteVehicle(input: DeleteVehicleRequest): DeleteVehicleResponse {
        val op = SdkHttpOperation.build<DeleteVehicleRequest, DeleteVehicleResponse> {
            serializer = DeleteVehicleOperationSerializer()
            deserializer = DeleteVehicleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteVehicle"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IoTAutobahnControlPlane", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleetwise"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes, or disassociates, a vehicle from a fleet. Disassociating a vehicle from a fleet doesn't delete the vehicle.
     *
     * If the vehicle is successfully dissociated from a fleet, Amazon Web Services IoT FleetWise sends back an HTTP 200 response with an empty body.
     */
    override suspend fun disassociateVehicleFleet(input: DisassociateVehicleFleetRequest): DisassociateVehicleFleetResponse {
        val op = SdkHttpOperation.build<DisassociateVehicleFleetRequest, DisassociateVehicleFleetResponse> {
            serializer = DisassociateVehicleFleetOperationSerializer()
            deserializer = DisassociateVehicleFleetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateVehicleFleet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IoTAutobahnControlPlane", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleetwise"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about a campaign.
     */
    override suspend fun getCampaign(input: GetCampaignRequest): GetCampaignResponse {
        val op = SdkHttpOperation.build<GetCampaignRequest, GetCampaignResponse> {
            serializer = GetCampaignOperationSerializer()
            deserializer = GetCampaignOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCampaign"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IoTAutobahnControlPlane", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleetwise"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about a created decoder manifest.
     */
    override suspend fun getDecoderManifest(input: GetDecoderManifestRequest): GetDecoderManifestResponse {
        val op = SdkHttpOperation.build<GetDecoderManifestRequest, GetDecoderManifestResponse> {
            serializer = GetDecoderManifestOperationSerializer()
            deserializer = GetDecoderManifestOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDecoderManifest"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IoTAutobahnControlPlane", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleetwise"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about a fleet.
     */
    override suspend fun getFleet(input: GetFleetRequest): GetFleetResponse {
        val op = SdkHttpOperation.build<GetFleetRequest, GetFleetResponse> {
            serializer = GetFleetOperationSerializer()
            deserializer = GetFleetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetFleet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IoTAutobahnControlPlane", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleetwise"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the logging options.
     */
    override suspend fun getLoggingOptions(input: GetLoggingOptionsRequest): GetLoggingOptionsResponse {
        val op = SdkHttpOperation.build<GetLoggingOptionsRequest, GetLoggingOptionsResponse> {
            serializer = GetLoggingOptionsOperationSerializer()
            deserializer = GetLoggingOptionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetLoggingOptions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IoTAutobahnControlPlane", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleetwise"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about a vehicle model (model manifest).
     */
    override suspend fun getModelManifest(input: GetModelManifestRequest): GetModelManifestResponse {
        val op = SdkHttpOperation.build<GetModelManifestRequest, GetModelManifestResponse> {
            serializer = GetModelManifestOperationSerializer()
            deserializer = GetModelManifestOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetModelManifest"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IoTAutobahnControlPlane", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleetwise"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about the status of registering your Amazon Web Services account, IAM, and Amazon Timestream resources so that Amazon Web Services IoT FleetWise can transfer your vehicle data to the Amazon Web Services Cloud.
     *
     * For more information, including step-by-step procedures, see [Setting up Amazon Web Services IoT FleetWise](https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/setting-up.html).
     *
     * This API operation doesn't require input parameters.
     */
    override suspend fun getRegisterAccountStatus(input: GetRegisterAccountStatusRequest): GetRegisterAccountStatusResponse {
        val op = SdkHttpOperation.build<GetRegisterAccountStatusRequest, GetRegisterAccountStatusResponse> {
            serializer = GetRegisterAccountStatusOperationSerializer()
            deserializer = GetRegisterAccountStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetRegisterAccountStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IoTAutobahnControlPlane", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleetwise"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about a signal catalog.
     */
    override suspend fun getSignalCatalog(input: GetSignalCatalogRequest): GetSignalCatalogResponse {
        val op = SdkHttpOperation.build<GetSignalCatalogRequest, GetSignalCatalogResponse> {
            serializer = GetSignalCatalogOperationSerializer()
            deserializer = GetSignalCatalogOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSignalCatalog"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IoTAutobahnControlPlane", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleetwise"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about a vehicle.
     */
    override suspend fun getVehicle(input: GetVehicleRequest): GetVehicleResponse {
        val op = SdkHttpOperation.build<GetVehicleRequest, GetVehicleResponse> {
            serializer = GetVehicleOperationSerializer()
            deserializer = GetVehicleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetVehicle"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IoTAutobahnControlPlane", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleetwise"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about the status of a vehicle with any associated campaigns.
     */
    override suspend fun getVehicleStatus(input: GetVehicleStatusRequest): GetVehicleStatusResponse {
        val op = SdkHttpOperation.build<GetVehicleStatusRequest, GetVehicleStatusResponse> {
            serializer = GetVehicleStatusOperationSerializer()
            deserializer = GetVehicleStatusOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetVehicleStatus"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IoTAutobahnControlPlane", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleetwise"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a decoder manifest using your existing CAN DBC file from your local device.
     */
    override suspend fun importDecoderManifest(input: ImportDecoderManifestRequest): ImportDecoderManifestResponse {
        val op = SdkHttpOperation.build<ImportDecoderManifestRequest, ImportDecoderManifestResponse> {
            serializer = ImportDecoderManifestOperationSerializer()
            deserializer = ImportDecoderManifestOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ImportDecoderManifest"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IoTAutobahnControlPlane", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleetwise"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a signal catalog using your existing VSS formatted content from your local device.
     */
    override suspend fun importSignalCatalog(input: ImportSignalCatalogRequest): ImportSignalCatalogResponse {
        val op = SdkHttpOperation.build<ImportSignalCatalogRequest, ImportSignalCatalogResponse> {
            serializer = ImportSignalCatalogOperationSerializer()
            deserializer = ImportSignalCatalogOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ImportSignalCatalog"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IoTAutobahnControlPlane", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleetwise"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists information about created campaigns.
     *
     * This API operation uses pagination. Specify the `nextToken` parameter in the request to return more results.
     */
    override suspend fun listCampaigns(input: ListCampaignsRequest): ListCampaignsResponse {
        val op = SdkHttpOperation.build<ListCampaignsRequest, ListCampaignsResponse> {
            serializer = ListCampaignsOperationSerializer()
            deserializer = ListCampaignsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListCampaigns"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IoTAutobahnControlPlane", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleetwise"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the network interfaces specified in a decoder manifest.
     *
     * This API operation uses pagination. Specify the `nextToken` parameter in the request to return more results.
     */
    override suspend fun listDecoderManifestNetworkInterfaces(input: ListDecoderManifestNetworkInterfacesRequest): ListDecoderManifestNetworkInterfacesResponse {
        val op = SdkHttpOperation.build<ListDecoderManifestNetworkInterfacesRequest, ListDecoderManifestNetworkInterfacesResponse> {
            serializer = ListDecoderManifestNetworkInterfacesOperationSerializer()
            deserializer = ListDecoderManifestNetworkInterfacesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDecoderManifestNetworkInterfaces"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IoTAutobahnControlPlane", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleetwise"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * A list of information about signal decoders specified in a decoder manifest.
     *
     * This API operation uses pagination. Specify the `nextToken` parameter in the request to return more results.
     */
    override suspend fun listDecoderManifestSignals(input: ListDecoderManifestSignalsRequest): ListDecoderManifestSignalsResponse {
        val op = SdkHttpOperation.build<ListDecoderManifestSignalsRequest, ListDecoderManifestSignalsResponse> {
            serializer = ListDecoderManifestSignalsOperationSerializer()
            deserializer = ListDecoderManifestSignalsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDecoderManifestSignals"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IoTAutobahnControlPlane", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleetwise"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists decoder manifests.
     *
     * This API operation uses pagination. Specify the `nextToken` parameter in the request to return more results.
     */
    override suspend fun listDecoderManifests(input: ListDecoderManifestsRequest): ListDecoderManifestsResponse {
        val op = SdkHttpOperation.build<ListDecoderManifestsRequest, ListDecoderManifestsResponse> {
            serializer = ListDecoderManifestsOperationSerializer()
            deserializer = ListDecoderManifestsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDecoderManifests"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IoTAutobahnControlPlane", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleetwise"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information for each created fleet in an Amazon Web Services account.
     *
     * This API operation uses pagination. Specify the `nextToken` parameter in the request to return more results.
     */
    override suspend fun listFleets(input: ListFleetsRequest): ListFleetsResponse {
        val op = SdkHttpOperation.build<ListFleetsRequest, ListFleetsResponse> {
            serializer = ListFleetsOperationSerializer()
            deserializer = ListFleetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListFleets"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IoTAutobahnControlPlane", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleetwise"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list of IDs for all fleets that the vehicle is associated with.
     *
     * This API operation uses pagination. Specify the `nextToken` parameter in the request to return more results.
     */
    override suspend fun listFleetsForVehicle(input: ListFleetsForVehicleRequest): ListFleetsForVehicleResponse {
        val op = SdkHttpOperation.build<ListFleetsForVehicleRequest, ListFleetsForVehicleResponse> {
            serializer = ListFleetsForVehicleOperationSerializer()
            deserializer = ListFleetsForVehicleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListFleetsForVehicle"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IoTAutobahnControlPlane", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleetwise"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists information about nodes specified in a vehicle model (model manifest).
     *
     * This API operation uses pagination. Specify the `nextToken` parameter in the request to return more results.
     */
    override suspend fun listModelManifestNodes(input: ListModelManifestNodesRequest): ListModelManifestNodesResponse {
        val op = SdkHttpOperation.build<ListModelManifestNodesRequest, ListModelManifestNodesResponse> {
            serializer = ListModelManifestNodesOperationSerializer()
            deserializer = ListModelManifestNodesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListModelManifestNodes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IoTAutobahnControlPlane", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleetwise"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list of vehicle models (model manifests).
     *
     * This API operation uses pagination. Specify the `nextToken` parameter in the request to return more results.
     */
    override suspend fun listModelManifests(input: ListModelManifestsRequest): ListModelManifestsResponse {
        val op = SdkHttpOperation.build<ListModelManifestsRequest, ListModelManifestsResponse> {
            serializer = ListModelManifestsOperationSerializer()
            deserializer = ListModelManifestsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListModelManifests"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IoTAutobahnControlPlane", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleetwise"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists of information about the signals (nodes) specified in a signal catalog.
     *
     * This API operation uses pagination. Specify the `nextToken` parameter in the request to return more results.
     */
    override suspend fun listSignalCatalogNodes(input: ListSignalCatalogNodesRequest): ListSignalCatalogNodesResponse {
        val op = SdkHttpOperation.build<ListSignalCatalogNodesRequest, ListSignalCatalogNodesResponse> {
            serializer = ListSignalCatalogNodesOperationSerializer()
            deserializer = ListSignalCatalogNodesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListSignalCatalogNodes"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IoTAutobahnControlPlane", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleetwise"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all the created signal catalogs in an Amazon Web Services account.
     *
     * You can use to list information about each signal (node) specified in a signal catalog.
     *
     * This API operation uses pagination. Specify the `nextToken` parameter in the request to return more results.
     */
    override suspend fun listSignalCatalogs(input: ListSignalCatalogsRequest): ListSignalCatalogsResponse {
        val op = SdkHttpOperation.build<ListSignalCatalogsRequest, ListSignalCatalogsResponse> {
            serializer = ListSignalCatalogsOperationSerializer()
            deserializer = ListSignalCatalogsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListSignalCatalogs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IoTAutobahnControlPlane", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleetwise"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the tags (metadata) you have assigned to the resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IoTAutobahnControlPlane", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleetwise"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list of summaries of created vehicles.
     *
     * This API operation uses pagination. Specify the `nextToken` parameter in the request to return more results.
     */
    override suspend fun listVehicles(input: ListVehiclesRequest): ListVehiclesResponse {
        val op = SdkHttpOperation.build<ListVehiclesRequest, ListVehiclesResponse> {
            serializer = ListVehiclesOperationSerializer()
            deserializer = ListVehiclesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListVehicles"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IoTAutobahnControlPlane", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleetwise"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves a list of summaries of all vehicles associated with a fleet.
     *
     * This API operation uses pagination. Specify the `nextToken` parameter in the request to return more results.
     */
    override suspend fun listVehiclesInFleet(input: ListVehiclesInFleetRequest): ListVehiclesInFleetResponse {
        val op = SdkHttpOperation.build<ListVehiclesInFleetRequest, ListVehiclesInFleetResponse> {
            serializer = ListVehiclesInFleetOperationSerializer()
            deserializer = ListVehiclesInFleetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListVehiclesInFleet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IoTAutobahnControlPlane", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleetwise"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates or updates the logging option.
     */
    override suspend fun putLoggingOptions(input: PutLoggingOptionsRequest): PutLoggingOptionsResponse {
        val op = SdkHttpOperation.build<PutLoggingOptionsRequest, PutLoggingOptionsResponse> {
            serializer = PutLoggingOptionsOperationSerializer()
            deserializer = PutLoggingOptionsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutLoggingOptions"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IoTAutobahnControlPlane", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleetwise"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Registers your Amazon Web Services account, IAM, and Amazon Timestream resources so Amazon Web Services IoT FleetWise can transfer your vehicle data to the Amazon Web Services Cloud. For more information, including step-by-step procedures, see [Setting up Amazon Web Services IoT FleetWise](https://docs.aws.amazon.com/iot-fleetwise/latest/developerguide/setting-up.html).
     *
     * An Amazon Web Services account is **not** the same thing as a "user account". An [Amazon Web Services user](https://docs.aws.amazon.com/IAM/latest/UserGuide/introduction_identity-management.html#intro-identity-users) is an identity that you create using Identity and Access Management (IAM) and takes the form of either an [IAM user](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users.html) or an [IAM role, both with credentials](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html). A single Amazon Web Services account can, and typically does, contain many users and roles.
     */
    override suspend fun registerAccount(input: RegisterAccountRequest): RegisterAccountResponse {
        val op = SdkHttpOperation.build<RegisterAccountRequest, RegisterAccountResponse> {
            serializer = RegisterAccountOperationSerializer()
            deserializer = RegisterAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RegisterAccount"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IoTAutobahnControlPlane", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleetwise"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds to or modifies the tags of the given resource. Tags are metadata which can be used to manage a resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IoTAutobahnControlPlane", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleetwise"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes the given tags (metadata) from the resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IoTAutobahnControlPlane", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleetwise"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a campaign.
     */
    override suspend fun updateCampaign(input: UpdateCampaignRequest): UpdateCampaignResponse {
        val op = SdkHttpOperation.build<UpdateCampaignRequest, UpdateCampaignResponse> {
            serializer = UpdateCampaignOperationSerializer()
            deserializer = UpdateCampaignOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateCampaign"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IoTAutobahnControlPlane", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleetwise"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a decoder manifest.
     *
     * A decoder manifest can only be updated when the status is `DRAFT`. Only `ACTIVE` decoder manifests can be associated with vehicles.
     */
    override suspend fun updateDecoderManifest(input: UpdateDecoderManifestRequest): UpdateDecoderManifestResponse {
        val op = SdkHttpOperation.build<UpdateDecoderManifestRequest, UpdateDecoderManifestResponse> {
            serializer = UpdateDecoderManifestOperationSerializer()
            deserializer = UpdateDecoderManifestOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDecoderManifest"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IoTAutobahnControlPlane", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleetwise"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the description of an existing fleet.
     *
     * If the fleet is successfully updated, Amazon Web Services IoT FleetWise sends back an HTTP 200 response with an empty HTTP body.
     */
    override suspend fun updateFleet(input: UpdateFleetRequest): UpdateFleetResponse {
        val op = SdkHttpOperation.build<UpdateFleetRequest, UpdateFleetResponse> {
            serializer = UpdateFleetOperationSerializer()
            deserializer = UpdateFleetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateFleet"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IoTAutobahnControlPlane", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleetwise"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a vehicle model (model manifest). If created vehicles are associated with a vehicle model, it can't be updated.
     */
    override suspend fun updateModelManifest(input: UpdateModelManifestRequest): UpdateModelManifestResponse {
        val op = SdkHttpOperation.build<UpdateModelManifestRequest, UpdateModelManifestResponse> {
            serializer = UpdateModelManifestOperationSerializer()
            deserializer = UpdateModelManifestOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateModelManifest"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IoTAutobahnControlPlane", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleetwise"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a signal catalog.
     */
    override suspend fun updateSignalCatalog(input: UpdateSignalCatalogRequest): UpdateSignalCatalogResponse {
        val op = SdkHttpOperation.build<UpdateSignalCatalogRequest, UpdateSignalCatalogResponse> {
            serializer = UpdateSignalCatalogOperationSerializer()
            deserializer = UpdateSignalCatalogOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateSignalCatalog"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IoTAutobahnControlPlane", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleetwise"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a vehicle.
     */
    override suspend fun updateVehicle(input: UpdateVehicleRequest): UpdateVehicleResponse {
        val op = SdkHttpOperation.build<UpdateVehicleRequest, UpdateVehicleResponse> {
            serializer = UpdateVehicleOperationSerializer()
            deserializer = UpdateVehicleOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateVehicle"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("IoTAutobahnControlPlane", "1.0"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "iotfleetwise"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "iotfleetwise")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
