// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotfleethub

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.iotfleethub.auth.DefaultIotFleetHubAuthSchemeProvider
import aws.sdk.kotlin.services.iotfleethub.auth.IotFleetHubAuthSchemeProvider
import aws.sdk.kotlin.services.iotfleethub.endpoints.DefaultIotFleetHubEndpointProvider
import aws.sdk.kotlin.services.iotfleethub.endpoints.IotFleetHubEndpointParameters
import aws.sdk.kotlin.services.iotfleethub.endpoints.IotFleetHubEndpointProvider
import aws.sdk.kotlin.services.iotfleethub.model.CreateApplicationRequest
import aws.sdk.kotlin.services.iotfleethub.model.CreateApplicationResponse
import aws.sdk.kotlin.services.iotfleethub.model.DeleteApplicationRequest
import aws.sdk.kotlin.services.iotfleethub.model.DeleteApplicationResponse
import aws.sdk.kotlin.services.iotfleethub.model.DescribeApplicationRequest
import aws.sdk.kotlin.services.iotfleethub.model.DescribeApplicationResponse
import aws.sdk.kotlin.services.iotfleethub.model.ListApplicationsRequest
import aws.sdk.kotlin.services.iotfleethub.model.ListApplicationsResponse
import aws.sdk.kotlin.services.iotfleethub.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.iotfleethub.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.iotfleethub.model.TagResourceRequest
import aws.sdk.kotlin.services.iotfleethub.model.TagResourceResponse
import aws.sdk.kotlin.services.iotfleethub.model.UntagResourceRequest
import aws.sdk.kotlin.services.iotfleethub.model.UntagResourceResponse
import aws.sdk.kotlin.services.iotfleethub.model.UpdateApplicationRequest
import aws.sdk.kotlin.services.iotfleethub.model.UpdateApplicationResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "IoTFleetHub"
public const val SdkVersion: String = "1.1.9"
public const val ServiceApiVersion: String = "2020-11-03"

/**
 * With Fleet Hub for AWS IoT Device Management you can build stand-alone web applications for monitoring the health of your device fleets.
 *
 * Fleet Hub for AWS IoT Device Management is in public preview and is subject to change.
 */
public interface IotFleetHubClient : SdkClient {
    /**
     * IotFleetHubClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, IotFleetHubClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "IotFleetHub",
                "IOTFLEETHUB",
                "iotfleethub",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, IotFleetHubClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): IotFleetHubClient = DefaultIotFleetHubClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: IotFleetHubEndpointProvider = builder.endpointProvider ?: DefaultIotFleetHubEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: IotFleetHubAuthSchemeProvider = builder.authSchemeProvider ?: DefaultIotFleetHubAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "IoTFleetHub"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: IotFleetHubEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: IotFleetHubAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a Fleet Hub for AWS IoT Device Management web application.
     *
     * Fleet Hub for AWS IoT Device Management is in public preview and is subject to change.
     */
    public suspend fun createApplication(input: CreateApplicationRequest): CreateApplicationResponse

    /**
     * Deletes a Fleet Hub for AWS IoT Device Management web application.
     *
     * Fleet Hub for AWS IoT Device Management is in public preview and is subject to change.
     */
    public suspend fun deleteApplication(input: DeleteApplicationRequest): DeleteApplicationResponse

    /**
     * Gets information about a Fleet Hub for AWS IoT Device Management web application.
     *
     * Fleet Hub for AWS IoT Device Management is in public preview and is subject to change.
     */
    public suspend fun describeApplication(input: DescribeApplicationRequest): DescribeApplicationResponse

    /**
     * Gets a list of Fleet Hub for AWS IoT Device Management web applications for the current account.
     *
     * Fleet Hub for AWS IoT Device Management is in public preview and is subject to change.
     */
    public suspend fun listApplications(input: ListApplicationsRequest = ListApplicationsRequest { }): ListApplicationsResponse

    /**
     * Lists the tags for the specified resource.
     *
     * Fleet Hub for AWS IoT Device Management is in public preview and is subject to change.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Adds to or modifies the tags of the specified resource. Tags are metadata which can be used to manage a resource.
     *
     * Fleet Hub for AWS IoT Device Management is in public preview and is subject to change.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes the specified tags (metadata) from the resource.
     *
     * Fleet Hub for AWS IoT Device Management is in public preview and is subject to change.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates information about a Fleet Hub for a AWS IoT Device Management web application.
     *
     * Fleet Hub for AWS IoT Device Management is in public preview and is subject to change.
     */
    public suspend fun updateApplication(input: UpdateApplicationRequest): UpdateApplicationResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun IotFleetHubClient.withConfig(block: IotFleetHubClient.Config.Builder.() -> Unit): IotFleetHubClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultIotFleetHubClient(newConfig)
}

/**
 * Creates a Fleet Hub for AWS IoT Device Management web application.
 *
 * Fleet Hub for AWS IoT Device Management is in public preview and is subject to change.
 */
public suspend inline fun IotFleetHubClient.createApplication(crossinline block: CreateApplicationRequest.Builder.() -> Unit): CreateApplicationResponse = createApplication(CreateApplicationRequest.Builder().apply(block).build())

/**
 * Deletes a Fleet Hub for AWS IoT Device Management web application.
 *
 * Fleet Hub for AWS IoT Device Management is in public preview and is subject to change.
 */
public suspend inline fun IotFleetHubClient.deleteApplication(crossinline block: DeleteApplicationRequest.Builder.() -> Unit): DeleteApplicationResponse = deleteApplication(DeleteApplicationRequest.Builder().apply(block).build())

/**
 * Gets information about a Fleet Hub for AWS IoT Device Management web application.
 *
 * Fleet Hub for AWS IoT Device Management is in public preview and is subject to change.
 */
public suspend inline fun IotFleetHubClient.describeApplication(crossinline block: DescribeApplicationRequest.Builder.() -> Unit): DescribeApplicationResponse = describeApplication(DescribeApplicationRequest.Builder().apply(block).build())

/**
 * Gets a list of Fleet Hub for AWS IoT Device Management web applications for the current account.
 *
 * Fleet Hub for AWS IoT Device Management is in public preview and is subject to change.
 */
public suspend inline fun IotFleetHubClient.listApplications(crossinline block: ListApplicationsRequest.Builder.() -> Unit): ListApplicationsResponse = listApplications(ListApplicationsRequest.Builder().apply(block).build())

/**
 * Lists the tags for the specified resource.
 *
 * Fleet Hub for AWS IoT Device Management is in public preview and is subject to change.
 */
public suspend inline fun IotFleetHubClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Adds to or modifies the tags of the specified resource. Tags are metadata which can be used to manage a resource.
 *
 * Fleet Hub for AWS IoT Device Management is in public preview and is subject to change.
 */
public suspend inline fun IotFleetHubClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes the specified tags (metadata) from the resource.
 *
 * Fleet Hub for AWS IoT Device Management is in public preview and is subject to change.
 */
public suspend inline fun IotFleetHubClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates information about a Fleet Hub for a AWS IoT Device Management web application.
 *
 * Fleet Hub for AWS IoT Device Management is in public preview and is subject to change.
 */
public suspend inline fun IotFleetHubClient.updateApplication(crossinline block: UpdateApplicationRequest.Builder.() -> Unit): UpdateApplicationResponse = updateApplication(UpdateApplicationRequest.Builder().apply(block).build())
