// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotfleethub.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.iotfleethub.model.ApplicationState
import aws.sdk.kotlin.services.iotfleethub.model.DescribeApplicationResponse
import aws.sdk.kotlin.services.iotfleethub.model.IoTFleetHubException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeApplicationOperationDeserializer: HttpDeserialize<DescribeApplicationResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeApplicationResponse {
        if (!response.status.isSuccess()) {
            throwDescribeApplicationError(context, response)
        }
        val builder = DescribeApplicationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeApplicationOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeApplicationError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw IoTFleetHubException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> IoTFleetHubException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeApplicationOperationBody(builder: DescribeApplicationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPLICATIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("applicationArn"))
    val APPLICATIONCREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("applicationCreationDate"))
    val APPLICATIONDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("applicationDescription"))
    val APPLICATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("applicationId"))
    val APPLICATIONLASTUPDATEDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("applicationLastUpdateDate"))
    val APPLICATIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("applicationName"))
    val APPLICATIONSTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("applicationState"))
    val APPLICATIONURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("applicationUrl"))
    val ERRORMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("errorMessage"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("roleArn"))
    val SSOCLIENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ssoClientId"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPLICATIONARN_DESCRIPTOR)
        field(APPLICATIONCREATIONDATE_DESCRIPTOR)
        field(APPLICATIONDESCRIPTION_DESCRIPTOR)
        field(APPLICATIONID_DESCRIPTOR)
        field(APPLICATIONLASTUPDATEDATE_DESCRIPTOR)
        field(APPLICATIONNAME_DESCRIPTOR)
        field(APPLICATIONSTATE_DESCRIPTOR)
        field(APPLICATIONURL_DESCRIPTOR)
        field(ERRORMESSAGE_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(SSOCLIENTID_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPLICATIONARN_DESCRIPTOR.index -> builder.applicationArn = deserializeString()
                APPLICATIONCREATIONDATE_DESCRIPTOR.index -> builder.applicationCreationDate = deserializeLong()
                APPLICATIONDESCRIPTION_DESCRIPTOR.index -> builder.applicationDescription = deserializeString()
                APPLICATIONID_DESCRIPTOR.index -> builder.applicationId = deserializeString()
                APPLICATIONLASTUPDATEDATE_DESCRIPTOR.index -> builder.applicationLastUpdateDate = deserializeLong()
                APPLICATIONNAME_DESCRIPTOR.index -> builder.applicationName = deserializeString()
                APPLICATIONSTATE_DESCRIPTOR.index -> builder.applicationState = deserializeString().let { ApplicationState.fromValue(it) }
                APPLICATIONURL_DESCRIPTOR.index -> builder.applicationUrl = deserializeString()
                ERRORMESSAGE_DESCRIPTOR.index -> builder.errorMessage = deserializeString()
                ROLEARN_DESCRIPTOR.index -> builder.roleArn = deserializeString()
                SSOCLIENTID_DESCRIPTOR.index -> builder.ssoClientId = deserializeString()
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
