// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.iotfleethub

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.iotfleethub.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.iotfleethub.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * With Fleet Hub for AWS IoT Device Management you can build stand-alone web applications for monitoring the health of your device fleets.
 *
 * Fleet Hub for AWS IoT Device Management is in public preview and is subject to change.
 */
interface IoTFleetHubClient : SdkClient {

    override val serviceName: String
        get() = "IoTFleetHub"
    /**
     * IoTFleetHubClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.Builder.() -> Unit): IoTFleetHubClient {
            val config = Config.Builder().apply(block).build()
            return DefaultIoTFleetHubClient(config)
        }

        operator fun invoke(config: Config): IoTFleetHubClient = DefaultIoTFleetHubClient(config)

        /**
         * Construct a [IoTFleetHubClient] by resolving the configuration from the current environment.
         */
        suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): IoTFleetHubClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            return DefaultIoTFleetHubClient(builder.build())
        }
    }

    class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig {
        val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        companion object {
            inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        class Builder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver? = null
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            var httpClientEngine: HttpClientEngine? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * AWS region to make requests to
             */
            var region: String? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a Fleet Hub for AWS IoT Device Management web application.
     *
     * Fleet Hub for AWS IoT Device Management is in public preview and is subject to change.
     */
    suspend fun createApplication(input: CreateApplicationRequest): CreateApplicationResponse

    /**
     * Deletes a Fleet Hub for AWS IoT Device Management web application.
     *
     * Fleet Hub for AWS IoT Device Management is in public preview and is subject to change.
     */
    suspend fun deleteApplication(input: DeleteApplicationRequest): DeleteApplicationResponse

    /**
     * Gets information about a Fleet Hub for AWS IoT Device Management web application.
     *
     * Fleet Hub for AWS IoT Device Management is in public preview and is subject to change.
     */
    suspend fun describeApplication(input: DescribeApplicationRequest): DescribeApplicationResponse

    /**
     * Gets a list of Fleet Hub for AWS IoT Device Management web applications for the current account.
     *
     * Fleet Hub for AWS IoT Device Management is in public preview and is subject to change.
     */
    suspend fun listApplications(input: ListApplicationsRequest = ListApplicationsRequest {}): ListApplicationsResponse

    /**
     * Lists the tags for the specified resource.
     *
     * Fleet Hub for AWS IoT Device Management is in public preview and is subject to change.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Adds to or modifies the tags of the specified resource. Tags are metadata which can be used to manage a resource.
     *
     * Fleet Hub for AWS IoT Device Management is in public preview and is subject to change.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes the specified tags (metadata) from the resource.
     *
     * Fleet Hub for AWS IoT Device Management is in public preview and is subject to change.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates information about a Fleet Hub for a AWS IoT Device Management web application.
     *
     * Fleet Hub for AWS IoT Device Management is in public preview and is subject to change.
     */
    suspend fun updateApplication(input: UpdateApplicationRequest): UpdateApplicationResponse
}

/**
 * Creates a Fleet Hub for AWS IoT Device Management web application.
 *
 * Fleet Hub for AWS IoT Device Management is in public preview and is subject to change.
 */
suspend inline fun IoTFleetHubClient.createApplication(crossinline block: CreateApplicationRequest.Builder.() -> Unit) = createApplication(CreateApplicationRequest.Builder().apply(block).build())

/**
 * Deletes a Fleet Hub for AWS IoT Device Management web application.
 *
 * Fleet Hub for AWS IoT Device Management is in public preview and is subject to change.
 */
suspend inline fun IoTFleetHubClient.deleteApplication(crossinline block: DeleteApplicationRequest.Builder.() -> Unit) = deleteApplication(DeleteApplicationRequest.Builder().apply(block).build())

/**
 * Gets information about a Fleet Hub for AWS IoT Device Management web application.
 *
 * Fleet Hub for AWS IoT Device Management is in public preview and is subject to change.
 */
suspend inline fun IoTFleetHubClient.describeApplication(crossinline block: DescribeApplicationRequest.Builder.() -> Unit) = describeApplication(DescribeApplicationRequest.Builder().apply(block).build())

/**
 * Gets a list of Fleet Hub for AWS IoT Device Management web applications for the current account.
 *
 * Fleet Hub for AWS IoT Device Management is in public preview and is subject to change.
 */
suspend inline fun IoTFleetHubClient.listApplications(crossinline block: ListApplicationsRequest.Builder.() -> Unit) = listApplications(ListApplicationsRequest.Builder().apply(block).build())

/**
 * Lists the tags for the specified resource.
 *
 * Fleet Hub for AWS IoT Device Management is in public preview and is subject to change.
 */
suspend inline fun IoTFleetHubClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Adds to or modifies the tags of the specified resource. Tags are metadata which can be used to manage a resource.
 *
 * Fleet Hub for AWS IoT Device Management is in public preview and is subject to change.
 */
suspend inline fun IoTFleetHubClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit) = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes the specified tags (metadata) from the resource.
 *
 * Fleet Hub for AWS IoT Device Management is in public preview and is subject to change.
 */
suspend inline fun IoTFleetHubClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit) = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates information about a Fleet Hub for a AWS IoT Device Management web application.
 *
 * Fleet Hub for AWS IoT Device Management is in public preview and is subject to change.
 */
suspend inline fun IoTFleetHubClient.updateApplication(crossinline block: UpdateApplicationRequest.Builder.() -> Unit) = updateApplication(UpdateApplicationRequest.Builder().apply(block).build())
