// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ioteventsdata.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information used to update the detector (instance).
 */
public class UpdateDetectorRequest private constructor(builder: Builder) {
    /**
     * The name of the detector model that created the detectors (instances).
     */
    public val detectorModelName: kotlin.String = requireNotNull(builder.detectorModelName) { "A non-null value must be provided for detectorModelName" }
    /**
     * The value of the input key attribute (identifying the device or system) that caused the creation of this detector (instance).
     */
    public val keyValue: kotlin.String? = builder.keyValue
    /**
     * The ID to assign to the detector update `"message"`. Each `"messageId"` must be unique within each batch sent.
     */
    public val messageId: kotlin.String = requireNotNull(builder.messageId) { "A non-null value must be provided for messageId" }
    /**
     * The new state, variable values, and timer settings of the detector (instance).
     */
    public val state: aws.sdk.kotlin.services.ioteventsdata.model.DetectorStateDefinition? = builder.state

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ioteventsdata.model.UpdateDetectorRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateDetectorRequest(")
        append("detectorModelName=$detectorModelName,")
        append("keyValue=$keyValue,")
        append("messageId=$messageId,")
        append("state=$state")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = detectorModelName.hashCode()
        result = 31 * result + (keyValue?.hashCode() ?: 0)
        result = 31 * result + (messageId.hashCode())
        result = 31 * result + (state?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateDetectorRequest

        if (detectorModelName != other.detectorModelName) return false
        if (keyValue != other.keyValue) return false
        if (messageId != other.messageId) return false
        if (state != other.state) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ioteventsdata.model.UpdateDetectorRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the detector model that created the detectors (instances).
         */
        public var detectorModelName: kotlin.String? = null
        /**
         * The value of the input key attribute (identifying the device or system) that caused the creation of this detector (instance).
         */
        public var keyValue: kotlin.String? = null
        /**
         * The ID to assign to the detector update `"message"`. Each `"messageId"` must be unique within each batch sent.
         */
        public var messageId: kotlin.String? = null
        /**
         * The new state, variable values, and timer settings of the detector (instance).
         */
        public var state: aws.sdk.kotlin.services.ioteventsdata.model.DetectorStateDefinition? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ioteventsdata.model.UpdateDetectorRequest) : this() {
            this.detectorModelName = x.detectorModelName
            this.keyValue = x.keyValue
            this.messageId = x.messageId
            this.state = x.state
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ioteventsdata.model.UpdateDetectorRequest = UpdateDetectorRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ioteventsdata.model.DetectorStateDefinition] inside the given [block]
         */
        public fun state(block: aws.sdk.kotlin.services.ioteventsdata.model.DetectorStateDefinition.Builder.() -> kotlin.Unit) {
            this.state = aws.sdk.kotlin.services.ioteventsdata.model.DetectorStateDefinition.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (detectorModelName == null) detectorModelName = ""
            if (messageId == null) messageId = ""
            return this
        }
    }
}
