// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ioteventsdata.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about a message.
 */
public class Message private constructor(builder: Builder) {
    /**
     * The name of the input into which the message payload is transformed.
     */
    public val inputName: kotlin.String = requireNotNull(builder.inputName) { "A non-null value must be provided for inputName" }
    /**
     * The ID to assign to the message. Within each batch sent, each `"messageId"` must be unique.
     */
    public val messageId: kotlin.String = requireNotNull(builder.messageId) { "A non-null value must be provided for messageId" }
    /**
     * The payload of the message. This can be a JSON string or a Base-64-encoded string representing binary data (in which case you must decode it).
     */
    public val payload: kotlin.ByteArray = requireNotNull(builder.payload) { "A non-null value must be provided for payload" }
    /**
     * The timestamp associated with the message.
     */
    public val timestamp: aws.sdk.kotlin.services.ioteventsdata.model.TimestampValue? = builder.timestamp

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ioteventsdata.model.Message = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Message(")
        append("inputName=$inputName,")
        append("messageId=$messageId,")
        append("payload=$payload,")
        append("timestamp=$timestamp")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = inputName.hashCode()
        result = 31 * result + (messageId.hashCode())
        result = 31 * result + (payload.contentHashCode())
        result = 31 * result + (timestamp?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Message

        if (inputName != other.inputName) return false
        if (messageId != other.messageId) return false
        if (!payload.contentEquals(other.payload)) return false
        if (timestamp != other.timestamp) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ioteventsdata.model.Message = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the input into which the message payload is transformed.
         */
        public var inputName: kotlin.String? = null
        /**
         * The ID to assign to the message. Within each batch sent, each `"messageId"` must be unique.
         */
        public var messageId: kotlin.String? = null
        /**
         * The payload of the message. This can be a JSON string or a Base-64-encoded string representing binary data (in which case you must decode it).
         */
        public var payload: kotlin.ByteArray? = null
        /**
         * The timestamp associated with the message.
         */
        public var timestamp: aws.sdk.kotlin.services.ioteventsdata.model.TimestampValue? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ioteventsdata.model.Message) : this() {
            this.inputName = x.inputName
            this.messageId = x.messageId
            this.payload = x.payload
            this.timestamp = x.timestamp
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ioteventsdata.model.Message = Message(this)

        /**
         * construct an [aws.sdk.kotlin.services.ioteventsdata.model.TimestampValue] inside the given [block]
         */
        public fun timestamp(block: aws.sdk.kotlin.services.ioteventsdata.model.TimestampValue.Builder.() -> kotlin.Unit) {
            this.timestamp = aws.sdk.kotlin.services.ioteventsdata.model.TimestampValue.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (inputName == null) inputName = ""
            if (messageId == null) messageId = ""
            if (payload == null) payload = ByteArray(0)
            return this
        }
    }
}
