// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ioteventsdata.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information used to disable the alarm.
 */
public class DisableAlarmActionRequest private constructor(builder: Builder) {
    /**
     * The name of the alarm model.
     */
    public val alarmModelName: kotlin.String = requireNotNull(builder.alarmModelName) { "A non-null value must be provided for alarmModelName" }
    /**
     * The value of the key used as a filter to select only the alarms associated with the [key](https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key).
     */
    public val keyValue: kotlin.String? = builder.keyValue
    /**
     * The note that you can leave when you disable the alarm.
     */
    public val note: kotlin.String? = builder.note
    /**
     * The request ID. Each ID must be unique within each batch.
     */
    public val requestId: kotlin.String = requireNotNull(builder.requestId) { "A non-null value must be provided for requestId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ioteventsdata.model.DisableAlarmActionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DisableAlarmActionRequest(")
        append("alarmModelName=$alarmModelName,")
        append("keyValue=$keyValue,")
        append("note=$note,")
        append("requestId=$requestId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = alarmModelName.hashCode()
        result = 31 * result + (keyValue?.hashCode() ?: 0)
        result = 31 * result + (note?.hashCode() ?: 0)
        result = 31 * result + (requestId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DisableAlarmActionRequest

        if (alarmModelName != other.alarmModelName) return false
        if (keyValue != other.keyValue) return false
        if (note != other.note) return false
        if (requestId != other.requestId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ioteventsdata.model.DisableAlarmActionRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the alarm model.
         */
        public var alarmModelName: kotlin.String? = null
        /**
         * The value of the key used as a filter to select only the alarms associated with the [key](https://docs.aws.amazon.com/iotevents/latest/apireference/API_CreateAlarmModel.html#iotevents-CreateAlarmModel-request-key).
         */
        public var keyValue: kotlin.String? = null
        /**
         * The note that you can leave when you disable the alarm.
         */
        public var note: kotlin.String? = null
        /**
         * The request ID. Each ID must be unique within each batch.
         */
        public var requestId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ioteventsdata.model.DisableAlarmActionRequest) : this() {
            this.alarmModelName = x.alarmModelName
            this.keyValue = x.keyValue
            this.note = x.note
            this.requestId = x.requestId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ioteventsdata.model.DisableAlarmActionRequest = DisableAlarmActionRequest(this)

        internal fun correctErrors(): Builder {
            if (alarmModelName == null) alarmModelName = ""
            if (requestId == null) requestId = ""
            return this
        }
    }
}
